/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public class ImageUtils {
    public static final String ERROR_WHILE_CONVERTING_IMAGE = "Error while converting image";
    private final WebDriver driver;

    public ImageUtils(WebDriver driver) {
        this.driver = driver;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public byte[] handleAlertAndTakeScreenshot() {
        String alertText = this.getDriver().switchTo().alert().getText();
        this.getDriver().switchTo().alert().accept();
        File scrFile = (File)((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
        try {
            BufferedImage screenshotImage = ImageIO.read(scrFile);
            BufferedImage alertImage = this.generateAlertImageWithLogo(alertText, screenshotImage.getWidth());
            FileUtils.deleteQuietly((File)scrFile);
            return this.toByteArray(this.stitchImages(screenshotImage, alertImage, false));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading screenshot file.", e);
        }
    }

    public static BufferedImage toBufferedImage(String fileName) throws FileNotFoundException {
        FileInputStream is = new FileInputStream(new File(fileName));
        try {
            BufferedImage image = ImageIO.read(is);
            ((InputStream)is).close();
            return image;
        }
        catch (IOException e) {
            throw new RuntimeException(ERROR_WHILE_CONVERTING_IMAGE, e);
        }
    }

    private byte[] toByteArray(BufferedImage image) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(ERROR_WHILE_CONVERTING_IMAGE, e);
        }
    }

    private BufferedImage stitchImages(BufferedImage image1, BufferedImage image2, boolean asOverlay) {
        if (asOverlay) {
            int x = Math.max(image1.getWidth(), image2.getWidth());
            int y = Math.max(image1.getHeight(), image2.getHeight());
            BufferedImage stitchedImage = new BufferedImage(x, y, 2);
            Graphics g = stitchedImage.getGraphics();
            g.drawImage(image1, 0, 0, null);
            g.drawImage(image2, image1.getWidth() - image2.getWidth(), image1.getHeight() - image2.getHeight(), null);
            return stitchedImage;
        }
        BufferedImage stitchedImage = new BufferedImage(image1.getWidth(), image1.getHeight() + image2.getHeight(), 1);
        Graphics graphics = stitchedImage.getGraphics();
        graphics.drawImage(image1, 0, 0, null);
        graphics.drawImage(image2, 0, image1.getHeight(), null);
        graphics.setColor(Color.BLACK);
        graphics.drawLine(0, image1.getHeight(), image1.getWidth(), image1.getHeight());
        return stitchedImage;
    }

    private BufferedImage generateAlertImageWithLogo(String alertText, int screenshotWidth) throws FileNotFoundException {
        BufferedImage alertImage = this.generateImageWithText(alertText, screenshotWidth, 200);
        BufferedImage logo = ImageUtils.toBufferedImage(ImageUtils.class.getResource("/fl_logo.png").getPath());
        return this.stitchImages(alertImage, logo, true);
    }

    private BufferedImage generateImageWithText(String text, int width, int height) {
        BufferedImage alertImage = new BufferedImage(width, height, 1);
        Graphics graphics = alertImage.getGraphics();
        graphics.setColor(new Color(220, 218, 218));
        graphics.fillRect(0, 0, width, height);
        graphics.setColor(Color.BLACK);
        graphics.setFont(new Font("SansSerif", 0, 15));
        this.drawStringMultiLine(graphics, text, width - 200 - 10);
        return alertImage;
    }

    private void drawStringMultiLine(Graphics g, String text, int lineWidth) {
        String[] words;
        FontMetrics m = g.getFontMetrics();
        int xPosition = 10;
        int yPosition = 25;
        for (String word : words = text.trim().split("\\b")) {
            if (xPosition + m.stringWidth(word) < lineWidth) {
                g.drawString(word, xPosition, yPosition);
                xPosition += m.stringWidth(word);
                continue;
            }
            xPosition = 10;
            g.drawString(word, xPosition, yPosition += m.getHeight());
            xPosition += m.stringWidth(word);
        }
    }
}

