/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.hook;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.components.ComponentInstantiator;
import org.fluentlenium.core.hook.FluentHook;
import org.fluentlenium.core.hook.HookChainBuilder;
import org.fluentlenium.core.hook.HookDefinition;
import org.fluentlenium.core.hook.HookException;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class DefaultHookChainBuilder
implements HookChainBuilder {
    private final FluentControl control;
    private final ComponentInstantiator instantiator;

    public DefaultHookChainBuilder(FluentControl control, ComponentInstantiator instantiator) {
        this.control = control;
        this.instantiator = instantiator;
    }

    @Override
    public List<FluentHook> build(Supplier<WebElement> elementSupplier, Supplier<ElementLocator> locator, Supplier<String> toStringSupplier, List<HookDefinition<?>> hooks) {
        ArrayList<FluentHook> chain = new ArrayList<FluentHook>();
        Supplier<WebElement> currentSupplier = elementSupplier;
        for (HookDefinition<?> hook : hooks) {
            FluentHook<?> newObject;
            try {
                newObject = this.newInstance(hook.getHookClass(), this.control, this.instantiator, currentSupplier, locator, toStringSupplier, hook.getOptions());
            }
            catch (NoSuchMethodException e) {
                throw new HookException(e);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new HookException(e);
            }
            FluentHook<?> hookInstance = newObject;
            currentSupplier = () -> hookInstance;
            chain.add(hookInstance);
        }
        return chain;
    }

    protected FluentHook<?> newInstance(Class<? extends FluentHook<?>> hookClass, FluentControl fluentControl, ComponentInstantiator instantiator, Supplier<WebElement> elementSupplier, Supplier<ElementLocator> locatorSupplier, Supplier<String> toStringSupplier, Object options) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return ReflectionUtils.newInstance(hookClass, fluentControl, instantiator, elementSupplier, locatorSupplier, toStringSupplier, options);
    }
}

