/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.css;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.fluentlenium.core.css.CssSupport;
import org.fluentlenium.core.script.JavascriptControl;
import org.fluentlenium.core.wait.AwaitControl;
import org.openqa.selenium.WebDriverException;

public class CssSupportImpl
implements CssSupport {
    private final JavascriptControl javascriptControl;
    private final AwaitControl awaitControl;

    public CssSupportImpl(JavascriptControl javascriptControl, AwaitControl awaitControl) {
        this.javascriptControl = javascriptControl;
        this.awaitControl = awaitControl;
    }

    @Override
    public void inject(String cssText) {
        String injectorJs;
        InputStream injectorScript = this.getClass().getResourceAsStream("/org/fluentlenium/core/css/injector.js");
        try {
            injectorJs = IOUtils.toString((InputStream)injectorScript, (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)injectorScript);
        }
        cssText = cssText.replace("\r\n", "").replace("\n", "");
        cssText = StringEscapeUtils.escapeEcmaScript((String)cssText);
        this.executeScriptRetry("cssText = \"" + cssText + "\";\n" + injectorJs);
    }

    @Override
    public void injectResource(String cssResourceName) {
        String cssText;
        InputStream cssStream = this.getClass().getResourceAsStream(cssResourceName);
        try {
            cssText = IOUtils.toString((InputStream)cssStream, (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)cssStream);
        }
        this.inject(cssText);
    }

    private void executeScriptRetry(String script) {
        int retries = 0;
        while (true) {
            try {
                this.javascriptControl.executeScript(script, new Object[0]);
            }
            catch (WebDriverException e) {
                if (++retries >= 10) {
                    throw e;
                }
                this.awaitControl.await().explicitlyFor(250L);
                continue;
            }
            break;
        }
    }
}

