/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.conditions.wait;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.conditions.Conditions;
import org.fluentlenium.core.conditions.ConditionsObject;
import org.fluentlenium.core.conditions.Negation;
import org.fluentlenium.core.conditions.message.MessageContext;
import org.fluentlenium.core.conditions.message.MessageProxy;
import org.fluentlenium.core.conditions.wait.WaitConditionProxy;
import org.fluentlenium.core.wait.FluentWait;
import org.openqa.selenium.internal.WrapsElement;

public class WaitConditionInvocationHandler<C extends Conditions<?>>
implements InvocationHandler {
    private final Class<C> conditionClass;
    private final Supplier<C> conditionSupplier;
    private final FluentWait wait;
    private String context;
    private boolean negation;

    public WaitConditionInvocationHandler(Class<C> conditionClass, FluentWait wait, String context, Supplier<C> conditionSupplier) {
        this.conditionClass = conditionClass;
        this.wait = wait;
        this.context = context;
        this.conditionSupplier = conditionSupplier;
    }

    protected C conditions() {
        return this.conditions(false);
    }

    protected C conditions(boolean ignoreNot) {
        Conditions conditions = (Conditions)this.conditionSupplier.get();
        return (C)this.applyNegation(conditions, ignoreNot);
    }

    protected C applyNegation(C conditions, boolean ignoreNegation) {
        if (!ignoreNegation && this.negation) {
            return (C)conditions.not();
        }
        return conditions;
    }

    protected C messageBuilder() {
        return this.messageBuilder(false);
    }

    protected C messageBuilder(boolean ignoreNegation) {
        Conditions conditions = (Conditions)MessageProxy.builder(this.conditionClass, this.context);
        conditions = this.applyNegation(conditions, ignoreNegation);
        return (C)conditions;
    }

    protected Function<String, String> messageCustomizer() {
        return Function.identity();
    }

    protected void until(Predicate<FluentControl> present, String message) {
        if (this.wait.hasMessageDefined()) {
            this.wait.untilPredicate(present);
        } else {
            message = this.messageCustomizer().apply(message);
            this.wait.withMessage(message).untilPredicate(present);
        }
    }

    protected void until(Predicate<FluentControl> present, Supplier<String> messageSupplier) {
        if (this.wait.hasMessageDefined()) {
            this.wait.untilPredicate(present);
        } else {
            Supplier<String> customMessageSupplier = () -> this.messageCustomizer().apply((String)messageSupplier.get());
            ((FluentWait)this.wait.withMessage((Supplier)customMessageSupplier)).untilPredicate(present);
        }
    }

    protected void until(C condition, C messageBuilder, Function<C, Boolean> conditionFunction) {
        Predicate<FluentControl> predicate = input -> (Boolean)conditionFunction.apply(condition);
        Supplier<String> messageSupplier = () -> {
            Object actualObject;
            conditionFunction.apply(messageBuilder);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(MessageProxy.message(messageBuilder));
            if (condition instanceof ConditionsObject && !((actualObject = ((ConditionsObject)((Object)condition)).getActualObject()) instanceof WrapsElement)) {
                stringBuilder.append(" (actual: ");
                stringBuilder.append(actualObject);
                stringBuilder.append(')');
            }
            return stringBuilder.toString();
        };
        this.until(predicate, messageSupplier);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> returnType;
        if (method.isAnnotationPresent(Negation.class)) {
            return this.buildNegationProxy();
        }
        if (method.isAnnotationPresent(MessageContext.class)) {
            this.context = this.context + " " + method.getAnnotation(MessageContext.class).value();
        }
        if (Boolean.TYPE.equals(returnType = method.getReturnType()) || Boolean.class.equals(returnType)) {
            return this.waitForCondition(method, args);
        }
        if (Conditions.class.isAssignableFrom(returnType)) {
            return this.buildChildProxy(method, args);
        }
        throw new IllegalStateException("An internal error has occurred.");
    }

    private Object buildChildProxy(Method method, Object[] args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method conditionGetter = this.conditions().getClass().getMethod(method.getName(), method.getParameterTypes());
        Conditions childConditions = (Conditions)conditionGetter.invoke(this.conditions(true), args);
        Conditions childProxy = WaitConditionProxy.custom(method.getReturnType(), this.wait, this.context, () -> childConditions);
        WaitConditionInvocationHandler childHandler = (WaitConditionInvocationHandler)Proxy.getInvocationHandler(childProxy);
        childHandler.negation = this.negation;
        return childProxy;
    }

    private boolean waitForCondition(Method method, Object[] args) {
        C messageBuilder = this.messageBuilder();
        this.until(this.conditions(), messageBuilder, input -> {
            try {
                return (Boolean)method.invoke(input, args);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("An internal error has occured while waiting", e);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                throw new IllegalStateException("An internal error has occured while waiting", e);
            }
        });
        return true;
    }

    private Conditions<?> buildNegationProxy() {
        C negationProxy = WaitConditionProxy.custom(this.conditionClass, this.wait, this.context, this.conditionSupplier);
        WaitConditionInvocationHandler negationHandler = (WaitConditionInvocationHandler)Proxy.getInvocationHandler(negationProxy);
        negationHandler.negation = !this.negation;
        return negationProxy;
    }
}

