/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.fluentlenium.core.components.ComponentInstantiator;
import org.fluentlenium.core.components.LazyComponents;
import org.fluentlenium.core.components.LazyComponentsListener;
import org.fluentlenium.core.domain.WrapsElements;
import org.openqa.selenium.WebElement;

public class LazyComponentList<T>
implements List<T>,
WrapsElements,
LazyComponents<T> {
    private final ComponentInstantiator instantiator;
    private final Class<T> componentClass;
    private final List<WebElement> elements;
    private final List<LazyComponentsListener<T>> lazyComponentsListeners = new ArrayList<LazyComponentsListener<T>>();
    private final AtomicReference<Object> list = new AtomicReference();

    public LazyComponentList(ComponentInstantiator instantiator, Class<T> componentClass, List<WebElement> elements) {
        this.componentClass = componentClass;
        this.instantiator = instantiator;
        this.elements = elements;
    }

    protected List<T> transformList() {
        ArrayList<T> components = new ArrayList<T>();
        LinkedHashMap<WebElement, T> componentMap = new LinkedHashMap<WebElement, T>();
        for (WebElement element : this.elements) {
            T component = this.instantiator.newComponent(this.componentClass, element);
            components.add(component);
            componentMap.put(element, component);
        }
        this.fireLazyComponentsInitialized(componentMap);
        return components;
    }

    protected void fireLazyComponentsInitialized(Map<WebElement, T> componentMap) {
        for (LazyComponentsListener<T> listener : this.lazyComponentsListeners) {
            listener.lazyComponentsInitialized(componentMap);
        }
    }

    @Override
    public boolean addLazyComponentsListener(LazyComponentsListener<T> listener) {
        return this.lazyComponentsListeners.add(listener);
    }

    @Override
    public boolean removeLazyComponentsListener(LazyComponentsListener<T> listener) {
        return this.lazyComponentsListeners.remove(listener);
    }

    @Override
    public boolean isLazy() {
        return true;
    }

    @Override
    public boolean isLazyInitialized() {
        return this.list == null;
    }

    @Override
    public List<WebElement> getWrappedElements() {
        return this.elements;
    }

    public String toString() {
        return this.isLazyInitialized() ? this.list.toString() : this.elements.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getList() {
        Object value = this.list.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.list;
            synchronized (atomicReference) {
                value = this.list.get();
                if (value == null) {
                    List<T> actualValue = this.transformList();
                    value = actualValue == null ? this.list : actualValue;
                    this.list.set(value);
                }
            }
        }
        return (List)(value == this.list ? null : value);
    }

    @Override
    public int size() {
        return this.getList().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.getList().contains(arg0);
    }

    @Override
    public Iterator<T> iterator() {
        return this.getList().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.getList().toArray(arg0);
    }

    @Override
    public boolean add(T arg0) {
        return this.getList().add(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        return this.getList().remove(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.getList().containsAll(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        return this.getList().addAll(arg0);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends T> arg1) {
        return this.getList().addAll(arg0, arg1);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.getList().removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.getList().retainAll(arg0);
    }

    @Override
    public void replaceAll(UnaryOperator<T> arg0) {
        this.getList().replaceAll(arg0);
    }

    @Override
    public void sort(Comparator<? super T> arg0) {
        this.getList().sort(arg0);
    }

    @Override
    public void clear() {
        this.getList().clear();
    }

    @Override
    public T get(int arg0) {
        return this.getList().get(arg0);
    }

    @Override
    public T set(int arg0, T arg1) {
        return this.getList().set(arg0, arg1);
    }

    @Override
    public void add(int arg0, T arg1) {
        this.getList().add(arg0, arg1);
    }

    @Override
    public T remove(int arg0) {
        return this.getList().remove(arg0);
    }

    @Override
    public int indexOf(Object arg0) {
        return this.getList().indexOf(arg0);
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.getList().lastIndexOf(arg0);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.getList().listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int arg0) {
        return this.getList().listIterator(arg0);
    }

    @Override
    public List<T> subList(int arg0, int arg1) {
        return this.getList().subList(arg0, arg1);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.getList().spliterator();
    }
}

