/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.fluentlenium.adapter.DefaultFluentControlContainer;
import org.fluentlenium.adapter.DefaultSharedMutator;
import org.fluentlenium.adapter.FluentAdapter;
import org.fluentlenium.adapter.FluentControlContainer;
import org.fluentlenium.adapter.SharedMutator;
import org.fluentlenium.adapter.SharedWebDriver;
import org.fluentlenium.adapter.SharedWebDriverContainer;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.openqa.selenium.WebDriverException;

public class FluentTestRunnerAdapter
extends FluentAdapter {
    private final SharedMutator sharedMutator;

    public FluentTestRunnerAdapter() {
        this(new DefaultFluentControlContainer());
    }

    public FluentTestRunnerAdapter(FluentControlContainer driverContainer) {
        this(driverContainer, new DefaultSharedMutator());
    }

    public FluentTestRunnerAdapter(SharedMutator sharedMutator) {
        this(new DefaultFluentControlContainer(), sharedMutator);
    }

    public FluentTestRunnerAdapter(FluentControlContainer driverContainer, SharedMutator sharedMutator) {
        super(driverContainer);
        this.sharedMutator = sharedMutator;
    }

    public static void afterClass(Class<?> testClass) {
        List<SharedWebDriver> sharedWebDrivers = SharedWebDriverContainer.INSTANCE.getTestClassDrivers(testClass);
        for (SharedWebDriver sharedWebDriver : sharedWebDrivers) {
            SharedWebDriverContainer.INSTANCE.quit(sharedWebDriver);
        }
    }

    protected void starting() {
        this.starting(this.getClass());
    }

    protected void starting(String testName) {
        this.starting(this.getClass(), testName);
    }

    protected void starting(Class<?> testClass) {
        this.starting(testClass, testClass.getName());
    }

    protected void starting(Class<?> testClass, String testName) {
        SharedMutator.EffectiveParameters<?> parameters = this.sharedMutator.getEffectiveParameters(testClass, testName, this.getDriverLifecycle());
        SharedWebDriver sharedWebDriver = null;
        Exception exception = null;
        try {
            sharedWebDriver = this.getSharedWebDriver(parameters);
        }
        catch (InterruptedException | ExecutionException e) {
            exception = e;
        }
        if (sharedWebDriver == null) {
            this.failed(testClass, testName);
            String exceptionMessage = null;
            if (exception != null) {
                exceptionMessage = exception.getMessage();
            }
            throw new WebDriverException("Browser failed to start, test [ " + testName + " ] execution interrupted." + (StringUtils.isEmpty((CharSequence)exceptionMessage) ? "" : "\nCaused by: [ " + exceptionMessage + "]"));
        }
        this.initFluent(sharedWebDriver.getDriver());
    }

    private SharedWebDriver getSharedWebDriver(SharedMutator.EffectiveParameters<?> parameters) throws ExecutionException, InterruptedException {
        return this.getSharedWebDriver(parameters, null);
    }

    protected SharedWebDriver getSharedWebDriver(SharedMutator.EffectiveParameters<?> parameters, ExecutorService webDriverExecutor) throws ExecutionException, InterruptedException {
        SharedWebDriver sharedWebDriver = null;
        ExecutorService setExecutorService = null;
        if (webDriverExecutor != null) {
            setExecutorService = webDriverExecutor;
        }
        for (int browserTimeoutRetryNo = 0; browserTimeoutRetryNo < this.getBrowserTimeoutRetries() && sharedWebDriver == null; ++browserTimeoutRetryNo) {
            webDriverExecutor = setExecutorService == null ? Executors.newSingleThreadExecutor() : setExecutorService;
            Future<SharedWebDriver> futureWebDriver = webDriverExecutor.submit(() -> SharedWebDriverContainer.INSTANCE.getOrCreateDriver(this::newWebDriver, parameters.getTestClass(), parameters.getTestName(), parameters.getDriverLifecycle()));
            webDriverExecutor.shutdown();
            try {
                if (!webDriverExecutor.awaitTermination(this.getBrowserTimeout(), TimeUnit.MILLISECONDS)) {
                    webDriverExecutor.shutdownNow();
                }
                sharedWebDriver = futureWebDriver.get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                webDriverExecutor.shutdownNow();
                throw e;
            }
        }
        return sharedWebDriver;
    }

    protected void finished() {
        this.finished(this.getClass());
    }

    protected void finished(String testName) {
        this.finished(this.getClass(), testName);
    }

    protected void finished(Class<?> testClass) {
        this.finished(testClass, testClass.getName());
    }

    protected void finished(Class<?> testClass, String testName) {
        SharedMutator.EffectiveParameters<?> sharedParameters;
        SharedWebDriver sharedWebDriver;
        ConfigurationProperties.DriverLifecycle driverLifecycle = this.getDriverLifecycle();
        if (driverLifecycle == ConfigurationProperties.DriverLifecycle.METHOD || driverLifecycle == ConfigurationProperties.DriverLifecycle.THREAD) {
            SharedMutator.EffectiveParameters<?> parameters = this.sharedMutator.getEffectiveParameters(testClass, testName, driverLifecycle);
            SharedWebDriver sharedWebDriver2 = SharedWebDriverContainer.INSTANCE.getDriver(parameters.getTestClass(), parameters.getTestName(), parameters.getDriverLifecycle());
            if (sharedWebDriver2 != null) {
                SharedWebDriverContainer.INSTANCE.quit(sharedWebDriver2);
            }
        } else if (this.getDeleteCookies() != null && this.getDeleteCookies().booleanValue() && (sharedWebDriver = SharedWebDriverContainer.INSTANCE.getDriver((sharedParameters = this.sharedMutator.getEffectiveParameters(testClass, testName, driverLifecycle)).getTestClass(), sharedParameters.getTestName(), sharedParameters.getDriverLifecycle())) != null) {
            sharedWebDriver.getDriver().manage().deleteAllCookies();
        }
        this.releaseFluent();
    }

    protected void failed() {
        this.failed(this.getClass());
    }

    protected void failed(String testName) {
        this.failed(this.getClass(), testName);
    }

    protected void failed(Class<?> testClass) {
        this.failed(testClass, testClass.getName());
    }

    protected void failed(Class<?> testClass, String testName) {
        this.failed(null, testClass, testName);
    }

    protected void failed(Throwable e, Class<?> testClass, String testName) {
        if (this.isFluentControlAvailable()) {
            try {
                if (this.getScreenshotMode() == ConfigurationProperties.TriggerMode.AUTOMATIC_ON_FAIL && this.canTakeScreenShot()) {
                    this.takeScreenShot(testClass.getSimpleName() + "_" + testName + ".png");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.getHtmlDumpMode() == ConfigurationProperties.TriggerMode.AUTOMATIC_ON_FAIL && this.getDriver() != null) {
                    this.takeHtmlDump(testClass.getSimpleName() + "_" + testName + ".html");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

