/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import com.google.common.base.Predicate;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.wait.BaseWaitConditions;
import org.fluentlenium.core.wait.FluentWait;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class FluentWaitPageConditions
extends BaseWaitConditions {
    private final FluentWait wait;
    private final WebDriver webDriver;
    private FluentPage page;

    protected FluentWaitPageConditions(FluentWait wait, WebDriver driver) {
        this.wait = wait;
        this.webDriver = driver;
    }

    protected FluentWaitPageConditions(FluentWait wait, WebDriver driver, FluentPage page) {
        this.wait = wait;
        this.webDriver = driver;
        this.page = page;
    }

    public boolean isLoaded() {
        if (!(this.webDriver instanceof JavascriptExecutor)) {
            throw new UnsupportedOperationException("Driver must support javascript execution to use this feature");
        }
        Predicate<FluentControl> isLoaded = new Predicate<FluentControl>(){

            public boolean apply(FluentControl fluent) {
                String result = fluent.executeScript("if (document.readyState) return document.readyState;", new Object[0]).getStringResult();
                return result != null && "complete".equals(result);
            }
        };
        this.until(this.wait, isLoaded, String.format("Page %s should be loaded.", this.webDriver.getCurrentUrl()));
        return true;
    }

    public boolean isAt() {
        if (this.page == null) {
            throw new IllegalArgumentException("You should use a page argument when you call the untilPage method to specify the page you want to be. Example : await().untilPage(myPage).isAt();");
        }
        Predicate<FluentControl> isLoaded = new Predicate<FluentControl>(){

            public boolean apply(FluentControl fluent) {
                try {
                    FluentWaitPageConditions.this.page.isAt();
                }
                catch (Error e) {
                    return false;
                }
                return true;
            }
        };
        this.until(this.wait, isLoaded, "");
        return true;
    }
}

