/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.conditions.Conditions;
import org.fluentlenium.core.conditions.message.MessageProxy;
import org.fluentlenium.core.wait.FluentWait;

public class BaseWaitConditions {
    protected Function<String, String> messageCustomizer() {
        return Functions.identity();
    }

    protected void until(FluentWait wait, Predicate<FluentControl> present, String message) {
        if (wait.hasMessageDefined()) {
            wait.untilPredicate(present);
        } else {
            message = (String)this.messageCustomizer().apply((Object)message);
            wait.withMessage(message).untilPredicate(present);
        }
    }

    protected void until(FluentWait wait, Predicate<FluentControl> present, final Supplier<String> messageSupplier) {
        if (wait.hasMessageDefined()) {
            wait.untilPredicate(present);
        } else {
            Supplier<String> customMessageSupplier = new Supplier<String>(){

                public String get() {
                    return (String)BaseWaitConditions.this.messageCustomizer().apply(messageSupplier.get());
                }
            };
            ((FluentWait)wait.withMessage((Supplier)customMessageSupplier)).untilPredicate(present);
        }
    }

    protected <T extends Conditions<?>> void until(FluentWait wait, final T condition, final T messageBuilder, final Function<T, Boolean> conditionFunction) {
        Predicate<FluentControl> predicate = new Predicate<FluentControl>(){

            public boolean apply(FluentControl input) {
                return (Boolean)conditionFunction.apply((Object)condition);
            }
        };
        Supplier<String> messageSupplier = new Supplier<String>(){

            public String get() {
                conditionFunction.apply((Object)messageBuilder);
                return MessageProxy.message(messageBuilder);
            }
        };
        this.until(wait, predicate, messageSupplier);
    }
}

