/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.page;

import org.openqa.selenium.By;
import org.openqa.selenium.support.CacheLookup;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.AbstractAnnotations;

public class ClassAnnotations
extends AbstractAnnotations {
    private final Class<?> containerClass;

    public ClassAnnotations(Class<?> containerClass) {
        this.containerClass = containerClass;
    }

    public boolean isLookupCached() {
        return this.containerClass.getAnnotation(CacheLookup.class) != null;
    }

    public By buildBy() {
        this.assertValidAnnotations();
        By ans = null;
        FindBys findBys = this.containerClass.getAnnotation(FindBys.class);
        if (findBys != null) {
            ans = this.buildByFromFindBys(findBys);
        }
        FindAll findAll = this.containerClass.getAnnotation(FindAll.class);
        if (ans == null && findAll != null) {
            ans = this.buildBysFromFindByOneOf(findAll);
        }
        FindBy findBy = this.containerClass.getAnnotation(FindBy.class);
        if (ans == null && findBy != null) {
            ans = this.buildByFromFindBy(findBy);
        }
        return ans;
    }

    protected Class<?> getContainerClass() {
        return this.containerClass;
    }

    protected void assertValidAnnotations() {
        FindBys findBys = this.containerClass.getAnnotation(FindBys.class);
        FindAll findAll = this.containerClass.getAnnotation(FindAll.class);
        FindBy findBy = this.containerClass.getAnnotation(FindBy.class);
        if (findBys != null && findBy != null) {
            throw new IllegalArgumentException("If you use a '@FindBys' annotation, you must not also use a '@FindBy' annotation");
        }
        if (findAll != null && findBy != null) {
            throw new IllegalArgumentException("If you use a '@FindAll' annotation, you must not also use a '@FindBy' annotation");
        }
        if (findAll != null && findBys != null) {
            throw new IllegalArgumentException("If you use a '@FindAll' annotation, you must not also use a '@FindBys' annotation");
        }
    }
}

