/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.filter;

import com.google.common.base.Predicate;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.filter.AttributeFilter;
import org.fluentlenium.core.filter.FilterBuilder;
import org.fluentlenium.core.filter.MatcherConstructor;
import org.fluentlenium.core.filter.PredicateFilter;

public final class FilterConstructor {
    private FilterConstructor() {
    }

    public static AttributeFilter withName(String name) {
        return new AttributeFilter("name", name);
    }

    public static AttributeFilter withId(String id) {
        return new AttributeFilter("id", id);
    }

    public static AttributeFilter withClass(String klass) {
        return new AttributeFilter("class", klass);
    }

    public static AttributeFilter withText(String text) {
        return new AttributeFilter("text", MatcherConstructor.equal(text));
    }

    public static AttributeFilter containingText(String text) {
        return new AttributeFilter("text", MatcherConstructor.contains(text));
    }

    public static FilterBuilder withText() {
        return new FilterBuilder("text");
    }

    public static AttributeFilter withTextContent(String text) {
        return new AttributeFilter("textContent", MatcherConstructor.equal(text));
    }

    public static AttributeFilter containingTextContent(String text) {
        return new AttributeFilter("textContent", MatcherConstructor.contains(text));
    }

    public static FilterBuilder withTextContent() {
        return new FilterBuilder("textContent");
    }

    public static FilterBuilder with(String attribute) {
        return new FilterBuilder(attribute);
    }

    public static FilterBuilder withName() {
        return new FilterBuilder("name");
    }

    public static FilterBuilder withId() {
        return new FilterBuilder("id");
    }

    public static FilterBuilder withClass() {
        return new FilterBuilder("class");
    }

    public static PredicateFilter withPredicate(Predicate<FluentWebElement> predicate) {
        return new PredicateFilter(predicate);
    }
}

