/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.filter;

import com.google.common.base.Predicate;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.filter.AttributeFilter;

public class AttributeFilterPredicate
implements Predicate<FluentWebElement> {
    private final AttributeFilter filter;

    public AttributeFilterPredicate(AttributeFilter filter) {
        this.filter = filter;
    }

    public boolean apply(FluentWebElement element) {
        String attribute = this.getAttributeValue(element);
        return this.filter != null && this.filter.getMatcher().isSatisfiedBy(attribute);
    }

    private String getAttributeValue(FluentWebElement element) {
        return "text".equalsIgnoreCase(this.filter.getAttribut()) ? element.text() : element.attribute(this.filter.getAttribut());
    }
}

