/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.events;

import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.components.DefaultComponentInstantiator;
import org.fluentlenium.core.events.ElementListener;
import org.fluentlenium.core.events.EventAdapter;
import org.fluentlenium.core.events.EventListener;
import org.fluentlenium.core.events.EventsSupport;
import org.fluentlenium.core.events.ExceptionListener;
import org.fluentlenium.core.events.FindByListener;
import org.fluentlenium.core.events.ListenerPriorityComparator;
import org.fluentlenium.core.events.NavigateAllListener;
import org.fluentlenium.core.events.NavigateListener;
import org.fluentlenium.core.events.NavigateToListener;
import org.fluentlenium.core.events.ScriptListener;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class EventsRegistry
implements WrapsDriver {
    private final EventFiringWebDriver eventDriver;
    private final EventsSupport support;
    private final DefaultComponentInstantiator instantiator;
    final List<NavigateToListener> beforeNavigateTo = new ArrayList<NavigateToListener>();
    final List<NavigateToListener> afterNavigateTo = new ArrayList<NavigateToListener>();
    final List<NavigateListener> beforeNavigateBack = new ArrayList<NavigateListener>();
    final List<NavigateListener> afterNavigateBack = new ArrayList<NavigateListener>();
    final List<NavigateListener> beforeNavigateForward = new ArrayList<NavigateListener>();
    final List<NavigateListener> afterNavigateForward = new ArrayList<NavigateListener>();
    final List<NavigateAllListener> beforeNavigate = new ArrayList<NavigateAllListener>();
    final List<NavigateAllListener> afterNavigate = new ArrayList<NavigateAllListener>();
    final List<NavigateListener> beforeNavigateRefresh = new ArrayList<NavigateListener>();
    final List<NavigateListener> afterNavigateRefresh = new ArrayList<NavigateListener>();
    final List<FindByListener> beforeFindBy = new ArrayList<FindByListener>();
    final List<FindByListener> afterFindBy = new ArrayList<FindByListener>();
    final List<ElementListener> beforeClickOn = new ArrayList<ElementListener>();
    final List<ElementListener> afterClickOn = new ArrayList<ElementListener>();
    final List<ElementListener> beforeChangeValueOf = new ArrayList<ElementListener>();
    final List<ElementListener> afterChangeValueOf = new ArrayList<ElementListener>();
    final List<ScriptListener> beforeScript = new ArrayList<ScriptListener>();
    final List<ScriptListener> afterScript = new ArrayList<ScriptListener>();
    final List<ExceptionListener> onException = new ArrayList<ExceptionListener>();

    public EventsRegistry(FluentControl control) {
        this.eventDriver = (EventFiringWebDriver)control.getDriver();
        this.support = new EventsSupport(this);
        this.instantiator = new DefaultComponentInstantiator(control);
        this.register(this.support);
    }

    public EventsRegistry register(WebDriverEventListener eventListener) {
        this.eventDriver.register(eventListener);
        return this;
    }

    public EventsRegistry unregister(WebDriverEventListener eventListener) {
        this.eventDriver.unregister(eventListener);
        return this;
    }

    public EventsRegistry register(EventListener eventListener) {
        this.eventDriver.register((WebDriverEventListener)new EventAdapter(eventListener, this.instantiator));
        return this;
    }

    public EventsRegistry unregister(EventListener eventListener) {
        this.eventDriver.unregister((WebDriverEventListener)new EventAdapter(eventListener, this.instantiator));
        return this;
    }

    public void close() {
        this.unregister(this.support);
    }

    public WebDriver getWrappedDriver() {
        return this.eventDriver.getWrappedDriver();
    }

    public EventsRegistry beforeNavigateTo(NavigateToListener listener) {
        this.beforeNavigateTo.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateTo(NavigateToListener listener) {
        this.afterNavigateTo.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigateBack(NavigateListener listener) {
        this.beforeNavigateBack.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateBack(NavigateListener listener) {
        this.afterNavigateBack.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigateForward(NavigateListener listener) {
        this.beforeNavigateForward.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateForward(NavigateListener listener) {
        this.afterNavigateForward.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigate(NavigateAllListener listener) {
        this.beforeNavigate.add(listener);
        return this;
    }

    public EventsRegistry afterNavigate(NavigateAllListener listener) {
        this.afterNavigate.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigateRefresh(NavigateListener listener) {
        this.beforeNavigateRefresh.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateRefresh(NavigateListener listener) {
        this.afterNavigateRefresh.add(listener);
        return this;
    }

    public EventsRegistry beforeFindBy(FindByListener listener) {
        this.beforeFindBy.add(listener);
        return this;
    }

    public EventsRegistry afterFindBy(FindByListener listener) {
        this.afterFindBy.add(listener);
        return this;
    }

    public EventsRegistry beforeClickOn(ElementListener listener) {
        this.beforeClickOn.add(listener);
        return this;
    }

    public EventsRegistry afterClickOn(ElementListener listener) {
        this.afterClickOn.add(listener);
        return this;
    }

    public EventsRegistry beforeChangeValueOf(ElementListener listener) {
        this.beforeChangeValueOf.add(listener);
        return this;
    }

    public EventsRegistry afterChangeValueOf(ElementListener listener) {
        this.afterChangeValueOf.add(listener);
        return this;
    }

    public EventsRegistry beforeScript(ScriptListener listener) {
        this.beforeScript.add(listener);
        return this;
    }

    public EventsRegistry afterScript(ScriptListener listener) {
        this.afterScript.add(listener);
        return this;
    }

    public EventsRegistry onException(ExceptionListener listener) {
        this.onException.add(listener);
        return this;
    }

    protected void sortListeners() {
        ListenerPriorityComparator comparator = new ListenerPriorityComparator();
        Collections.sort(this.beforeNavigateTo, comparator);
        Collections.sort(this.afterNavigateTo, comparator);
        Collections.sort(this.beforeNavigateBack, comparator);
        Collections.sort(this.afterNavigateBack, comparator);
        Collections.sort(this.beforeNavigateForward, comparator);
        Collections.sort(this.afterNavigateForward, comparator);
        Collections.sort(this.beforeNavigate, comparator);
        Collections.sort(this.afterNavigate, comparator);
        Collections.sort(this.beforeNavigateRefresh, comparator);
        Collections.sort(this.afterNavigateRefresh, comparator);
        Collections.sort(this.beforeFindBy, comparator);
        Collections.sort(this.afterFindBy, comparator);
        Collections.sort(this.beforeClickOn, comparator);
        Collections.sort(this.afterClickOn, comparator);
        Collections.sort(this.beforeChangeValueOf, comparator);
        Collections.sort(this.afterChangeValueOf, comparator);
        Collections.sort(this.beforeScript, comparator);
        Collections.sort(this.afterScript, comparator);
        Collections.sort(this.onException, comparator);
    }

    public void unregisterContainer(Object container) {
        this.unregisterContainer(this.beforeNavigateTo, container);
        this.unregisterContainer(this.afterNavigateTo, container);
        this.unregisterContainer(this.beforeNavigateBack, container);
        this.unregisterContainer(this.afterNavigateBack, container);
        this.unregisterContainer(this.beforeNavigateForward, container);
        this.unregisterContainer(this.afterNavigateForward, container);
        this.unregisterContainer(this.beforeNavigate, container);
        this.unregisterContainer(this.afterNavigate, container);
        this.unregisterContainer(this.beforeNavigateRefresh, container);
        this.unregisterContainer(this.afterNavigateRefresh, container);
        this.unregisterContainer(this.beforeFindBy, container);
        this.unregisterContainer(this.afterFindBy, container);
        this.unregisterContainer(this.beforeClickOn, container);
        this.unregisterContainer(this.afterClickOn, container);
        this.unregisterContainer(this.beforeChangeValueOf, container);
        this.unregisterContainer(this.afterChangeValueOf, container);
        this.unregisterContainer(this.beforeScript, container);
        this.unregisterContainer(this.afterScript, container);
        this.unregisterContainer(this.onException, container);
    }

    private void unregisterContainer(Iterable iterable, Object container) {
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof ContainerListener) || next != container) continue;
            iterator.remove();
        }
    }
}

