/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.events;

import com.google.common.base.Function;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.events.AbstractAnnotationListener;
import org.fluentlenium.core.events.ElementListener;
import org.fluentlenium.core.events.EventAnnotationsException;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.WebDriver;

class AnnotationElementListener
extends AbstractAnnotationListener
implements ElementListener {
    private final Method method;
    private final String annotationName;

    AnnotationElementListener(Method method, Object container, String annotationName, int priority) {
        super(container, priority);
        this.method = method;
        this.annotationName = annotationName;
    }

    protected Function<Class<?>, Object> getArgsFunction(final FluentWebElement element, final WebDriver driver) {
        return new Function<Class<?>, Object>(){

            public Object apply(Class<?> input) {
                if (input.isAssignableFrom(FluentWebElement.class)) {
                    return element;
                }
                if (input.isAssignableFrom(WebDriver.class)) {
                    return driver;
                }
                return null;
            }
        };
    }

    @Override
    public void on(FluentWebElement element, WebDriver driver) {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Object[] args = ReflectionUtils.toArgs(this.getArgsFunction(element, driver), parameterTypes);
        try {
            ReflectionUtils.invoke(this.method, this.getContainer(), args);
        }
        catch (IllegalAccessException e) {
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + this.method, e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + this.method, e);
        }
    }
}

