/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.domain;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.fluentlenium.configuration.ConfigurationFactory;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.action.Fill;
import org.fluentlenium.core.action.FillSelect;
import org.fluentlenium.core.action.FluentActions;
import org.fluentlenium.core.action.FluentJavascriptActionsImpl;
import org.fluentlenium.core.action.KeyboardElementActions;
import org.fluentlenium.core.action.MouseElementActions;
import org.fluentlenium.core.action.WindowAction;
import org.fluentlenium.core.alert.Alert;
import org.fluentlenium.core.axes.Axes;
import org.fluentlenium.core.components.ComponentInstantiator;
import org.fluentlenium.core.conditions.FluentConditions;
import org.fluentlenium.core.conditions.WebElementConditions;
import org.fluentlenium.core.css.CssSupport;
import org.fluentlenium.core.domain.Component;
import org.fluentlenium.core.domain.ComponentList;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentListImpl;
import org.fluentlenium.core.events.EventsRegistry;
import org.fluentlenium.core.hook.FluentHook;
import org.fluentlenium.core.hook.HookControl;
import org.fluentlenium.core.hook.HookControlImpl;
import org.fluentlenium.core.hook.HookDefinition;
import org.fluentlenium.core.inject.ContainerContext;
import org.fluentlenium.core.label.FluentLabel;
import org.fluentlenium.core.label.FluentLabelImpl;
import org.fluentlenium.core.proxy.FluentProxyState;
import org.fluentlenium.core.proxy.LocatorHandler;
import org.fluentlenium.core.proxy.LocatorProxies;
import org.fluentlenium.core.script.FluentJavascript;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.search.SearchControl;
import org.fluentlenium.core.search.SearchFilter;
import org.fluentlenium.core.wait.FluentWaitElement;
import org.fluentlenium.utils.SupplierOfInstance;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class FluentWebElement
extends Component
implements WrapsElement,
FluentActions<FluentWebElement, FluentWebElement>,
FluentProxyState<FluentWebElement>,
SearchControl<FluentWebElement>,
HookControl<FluentWebElement>,
FluentLabel<FluentWebElement> {
    private final Search search;
    private final Axes axes;
    private final MouseElementActions mouseActions;
    private final KeyboardElementActions keyboardActions;
    private final WebElementConditions conditions;
    private final HookControlImpl<FluentWebElement> hookControl;
    private final FluentLabel<FluentWebElement> label;
    private final FluentJavascriptActionsImpl<FluentWebElement> javascriptActions;

    public FluentWebElement(WebElement element, FluentControl control, ComponentInstantiator instantiator) {
        super(element, control, instantiator);
        this.hookControl = new HookControlImpl<FluentWebElement>(this, this.webElement, this.control, this.instantiator, new Supplier<FluentWebElement>(){

            public FluentWebElement get() {
                LocatorHandler locatorHandler = LocatorProxies.getLocatorHandler(FluentWebElement.this.getElement());
                ElementLocator locator = locatorHandler.getLocator();
                WebElement noHookElement = LocatorProxies.createWebElement(locator);
                return (FluentWebElement)FluentWebElement.this.newComponent(FluentWebElement.this.getClass(), noHookElement);
            }
        });
        this.search = new Search((SearchContext)element, this.instantiator);
        this.axes = new Axes(element, this.instantiator);
        this.mouseActions = new MouseElementActions(this.control.getDriver(), element);
        this.keyboardActions = new KeyboardElementActions(this.control.getDriver(), element);
        this.conditions = new WebElementConditions(this);
        this.label = new FluentLabelImpl<FluentWebElement>(this, new Supplier<String>(){

            public String get() {
                return FluentWebElement.this.getElement().toString();
            }
        });
        this.javascriptActions = new FluentJavascriptActionsImpl<FluentWebElement>(this, this.control, new SupplierOfInstance<FluentWebElement>(this));
    }

    private FluentControl getFluentControl() {
        return this.control;
    }

    private HookControl<FluentWebElement> getHookControl() {
        return this.hookControl;
    }

    private FluentJavascriptActionsImpl<FluentWebElement> getJavascriptActions() {
        return this.javascriptActions;
    }

    @Override
    public FluentWebElement click() {
        this.webElement.click();
        return this;
    }

    @Override
    public FluentWebElement doubleClick() {
        this.mouse().doubleClick();
        return this;
    }

    @Override
    public FluentWebElement contextClick() {
        this.mouseActions.contextClick();
        return this;
    }

    @Override
    public boolean present() {
        return LocatorProxies.present(this.webElement);
    }

    @Override
    public FluentWebElement now() {
        LocatorProxies.now(this.webElement);
        return this;
    }

    @Override
    public FluentWebElement now(boolean force) {
        if (force) {
            this.reset();
        }
        return this.now();
    }

    @Override
    public FluentWebElement reset() {
        LocatorProxies.reset(this.webElement);
        return this;
    }

    @Override
    public boolean loaded() {
        return LocatorProxies.loaded(this.webElement);
    }

    public Axes axes() {
        return this.axes;
    }

    public FluentConditions conditions() {
        return this.conditions;
    }

    public FluentWaitElement await() {
        return new FluentWaitElement(this.control.await(), this);
    }

    public MouseElementActions mouse() {
        return this.mouseActions;
    }

    public KeyboardElementActions keyboard() {
        return this.keyboardActions;
    }

    public <T> T as(Class<T> componentClass) {
        return this.instantiator.newComponent(componentClass, this.getElement());
    }

    public FluentWebElement clear() {
        if (!this.isInputOfTypeFile()) {
            this.webElement.clear();
        }
        return this;
    }

    @Override
    public FluentWebElement submit() {
        this.webElement.submit();
        return this;
    }

    @Override
    public FluentWebElement write(String ... text) {
        this.clear();
        if (text.length != 0) {
            this.webElement.sendKeys(new CharSequence[]{text[0]});
        }
        return this;
    }

    public String name() {
        return this.webElement.getAttribute("name");
    }

    public String attribute(String name) {
        return this.webElement.getAttribute(name);
    }

    public String id() {
        return this.webElement.getAttribute("id");
    }

    public String text() {
        return this.webElement.getText();
    }

    public String textContent() {
        return this.webElement.getAttribute("textContent");
    }

    public String value() {
        return this.webElement.getAttribute("value");
    }

    public boolean displayed() {
        return this.webElement.isDisplayed();
    }

    public boolean enabled() {
        return this.webElement.isEnabled();
    }

    public boolean selected() {
        return this.webElement.isSelected();
    }

    public boolean clickable() {
        return ExpectedConditions.elementToBeClickable((WebElement)this.getElement()).apply((Object)this.control.getDriver()) != null;
    }

    public boolean stale() {
        return (Boolean)ExpectedConditions.stalenessOf((WebElement)this.getElement()).apply((Object)this.control.getDriver());
    }

    public String tagName() {
        return this.webElement.getTagName();
    }

    public WebElement getElement() {
        return this.webElement;
    }

    public WebElement getWrappedElement() {
        return this.getElement();
    }

    public Dimension size() {
        return this.webElement.getSize();
    }

    public FluentList<FluentWebElement> asList() {
        return this.instantiator.asComponentList(FluentListImpl.class, FluentWebElement.class, Arrays.asList(this.webElement));
    }

    @Override
    public FluentList<FluentWebElement> $(String selector, SearchFilter ... filters) {
        return this.find(selector, filters);
    }

    @Override
    public FluentWebElement el(String selector, SearchFilter ... filters) {
        return this.find(selector, filters).first();
    }

    @Override
    public FluentList<FluentWebElement> $(SearchFilter ... filters) {
        return this.find(filters);
    }

    @Override
    public FluentWebElement el(SearchFilter ... filters) {
        return this.find(filters).first();
    }

    @Override
    public FluentList<FluentWebElement> $(By locator, SearchFilter ... filters) {
        return this.find(locator, filters);
    }

    @Override
    public FluentWebElement el(By locator, SearchFilter ... filters) {
        return this.find(locator, filters).first();
    }

    @Override
    public FluentList<FluentWebElement> find(By locator, SearchFilter ... filters) {
        return this.search.find(locator, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(String selector, SearchFilter ... filters) {
        return this.search.find(selector, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(SearchFilter ... filters) {
        return this.search.find(filters);
    }

    public String html() {
        return this.webElement.getAttribute("innerHTML");
    }

    @Override
    public Fill fill() {
        return new Fill<FluentWebElement>(this);
    }

    @Override
    public FillSelect fillSelect() {
        return new FillSelect<FluentWebElement>(this);
    }

    @Override
    public FluentWebElement frame() {
        this.window().switchTo().frame(this);
        return this;
    }

    @Override
    public Optional<FluentWebElement> optional() {
        if (this.present()) {
            return Optional.of((Object)this);
        }
        return Optional.absent();
    }

    private boolean isInputOfTypeFile() {
        return "input".equalsIgnoreCase(this.tagName()) && "file".equalsIgnoreCase(this.attribute("type"));
    }

    void setHookRestoreStack(Stack<List<HookDefinition<?>>> hookRestoreStack) {
        this.hookControl.setHookRestoreStack(hookRestoreStack);
    }

    public String toString() {
        return this.label.toString();
    }

    @Override
    public FluentWebElement withLabel(String label) {
        return this.label.withLabel(label);
    }

    @Override
    public FluentWebElement withLabelHint(String ... labelHint) {
        return this.label.withLabelHint(labelHint);
    }

    public FluentJavascript executeScript(String script, Object ... args) {
        return this.getFluentControl().executeScript(script, args);
    }

    public FluentJavascript executeAsyncScript(String script, Object ... args) {
        return this.getFluentControl().executeAsyncScript(script, args);
    }

    public Alert alert() {
        return this.getFluentControl().alert();
    }

    public void takeHtmlDump() {
        this.getFluentControl().takeHtmlDump();
    }

    public void takeHtmlDump(String fileName) {
        this.getFluentControl().takeHtmlDump(fileName);
    }

    public boolean canTakeScreenShot() {
        return this.getFluentControl().canTakeScreenShot();
    }

    public void takeScreenShot() {
        this.getFluentControl().takeScreenShot();
    }

    public void takeScreenShot(String fileName) {
        this.getFluentControl().takeScreenShot(fileName);
    }

    public EventsRegistry events() {
        return this.getFluentControl().events();
    }

    public <P extends FluentPage> P goTo(P page) {
        return this.getFluentControl().goTo(page);
    }

    public void goTo(String url) {
        this.getFluentControl().goTo(url);
    }

    public void goToInNewTab(String url) {
        this.getFluentControl().goToInNewTab(url);
    }

    public void switchTo(FluentList<? extends FluentWebElement> elements) {
        this.getFluentControl().switchTo(elements);
    }

    public void switchTo(FluentWebElement element) {
        this.getFluentControl().switchTo(element);
    }

    public void switchTo() {
        this.getFluentControl().switchTo();
    }

    public void switchToDefault() {
        this.getFluentControl().switchToDefault();
    }

    public String pageSource() {
        return this.getFluentControl().pageSource();
    }

    public WindowAction window() {
        return this.getFluentControl().window();
    }

    public Set<Cookie> getCookies() {
        return this.getFluentControl().getCookies();
    }

    public Cookie getCookie(String name) {
        return this.getFluentControl().getCookie(name);
    }

    public String url() {
        return this.getFluentControl().url();
    }

    public WebDriver getDriver() {
        return this.getFluentControl().getDriver();
    }

    public CssSupport css() {
        return this.getFluentControl().css();
    }

    public ContainerContext inject(Object container) {
        return this.getFluentControl().inject(container);
    }

    public ContainerContext[] inject(Object ... containers) {
        return this.getFluentControl().inject(containers);
    }

    public <T> T newInstance(Class<T> cls) {
        return this.getFluentControl().newInstance(cls);
    }

    public FluentWebElement newFluent(WebElement element) {
        return this.getFluentControl().newFluent(element);
    }

    public <T> T newComponent(Class<T> componentClass, WebElement element) {
        return this.getFluentControl().newComponent(componentClass, element);
    }

    public FluentList<FluentWebElement> newFluentList() {
        return this.getFluentControl().newFluentList();
    }

    public FluentList<FluentWebElement> newFluentList(FluentWebElement ... elements) {
        return this.getFluentControl().newFluentList(elements);
    }

    public FluentList<FluentWebElement> newFluentList(List<FluentWebElement> elements) {
        return this.getFluentControl().newFluentList(elements);
    }

    public FluentList<FluentWebElement> asFluentList(WebElement ... elements) {
        return this.getFluentControl().asFluentList(elements);
    }

    public FluentList<FluentWebElement> asFluentList(Iterable<WebElement> elements) {
        return this.getFluentControl().asFluentList(elements);
    }

    public FluentList<FluentWebElement> asFluentList(List<WebElement> elements) {
        return this.getFluentControl().asFluentList(elements);
    }

    public <T extends FluentWebElement> FluentList<T> newFluentList(Class<T> componentClass) {
        return this.getFluentControl().newFluentList(componentClass);
    }

    public <T extends FluentWebElement> FluentList<T> newFluentList(Class<T> componentClass, T ... elements) {
        return this.getFluentControl().newFluentList(componentClass, (FluentWebElement[])elements);
    }

    public <T extends FluentWebElement> FluentList<T> newFluentList(Class<T> componentClass, List<T> elements) {
        return this.getFluentControl().newFluentList(componentClass, elements);
    }

    public <T extends FluentWebElement> FluentList<T> asFluentList(Class<T> componentClass, WebElement ... elements) {
        return this.getFluentControl().asFluentList(componentClass, elements);
    }

    public <T extends FluentWebElement> FluentList<T> asFluentList(Class<T> componentClass, Iterable<WebElement> elements) {
        return this.getFluentControl().asFluentList(componentClass, elements);
    }

    public <T extends FluentWebElement> FluentList<T> asFluentList(Class<T> componentClass, List<WebElement> elements) {
        return this.getFluentControl().asFluentList(componentClass, elements);
    }

    public <T> ComponentList<T> newComponentList(Class<T> componentClass) {
        return this.getFluentControl().newComponentList(componentClass);
    }

    public <T> ComponentList<T> asComponentList(Class<T> componentClass, WebElement ... elements) {
        return this.getFluentControl().asComponentList(componentClass, elements);
    }

    public <T> ComponentList<T> asComponentList(Class<T> componentClass, Iterable<WebElement> elements) {
        return this.getFluentControl().asComponentList(componentClass, elements);
    }

    public <T> ComponentList<T> asComponentList(Class<T> componentClass, List<WebElement> elements) {
        return this.getFluentControl().asComponentList(componentClass, elements);
    }

    public <T> ComponentList<T> newComponentList(Class<T> componentClass, T ... componentsList) {
        return this.getFluentControl().newComponentList(componentClass, componentsList);
    }

    public <T> ComponentList<T> newComponentList(Class<T> componentClass, List<T> componentsList) {
        return this.getFluentControl().newComponentList(componentClass, componentsList);
    }

    public <L extends List<T>, T> L newComponentList(Class<L> listClass, Class<T> componentClass) {
        return this.getFluentControl().newComponentList(listClass, componentClass);
    }

    public <L extends List<T>, T> L asComponentList(Class<L> listClass, Class<T> componentClass, WebElement ... elements) {
        return this.getFluentControl().asComponentList(listClass, componentClass, elements);
    }

    public <L extends List<T>, T> L asComponentList(Class<L> listClass, Class<T> componentClass, Iterable<WebElement> elements) {
        return this.getFluentControl().asComponentList(listClass, componentClass, elements);
    }

    public <L extends List<T>, T> L asComponentList(Class<L> listClass, Class<T> componentClass, List<WebElement> elements) {
        return this.getFluentControl().asComponentList(listClass, componentClass, elements);
    }

    public <L extends List<T>, T> L newComponentList(Class<L> listClass, Class<T> componentClass, T ... componentsList) {
        return this.getFluentControl().newComponentList(listClass, componentClass, componentsList);
    }

    public <L extends List<T>, T> L newComponentList(Class<L> listClass, Class<T> componentClass, List<T> componentsList) {
        return this.getFluentControl().newComponentList(listClass, componentClass, componentsList);
    }

    public boolean isComponentClass(Class<?> componentClass) {
        return this.getFluentControl().isComponentClass(componentClass);
    }

    public boolean isComponentListClass(Class<? extends List<?>> componentListClass) {
        return this.getFluentControl().isComponentListClass(componentListClass);
    }

    public String getWebDriver() {
        return this.getFluentControl().getWebDriver();
    }

    public String getRemoteUrl() {
        return this.getFluentControl().getRemoteUrl();
    }

    public Capabilities getCapabilities() {
        return this.getFluentControl().getCapabilities();
    }

    public String getBaseUrl() {
        return this.getFluentControl().getBaseUrl();
    }

    public ConfigurationProperties.DriverLifecycle getDriverLifecycle() {
        return this.getFluentControl().getDriverLifecycle();
    }

    public Boolean getDeleteCookies() {
        return this.getFluentControl().getDeleteCookies();
    }

    public Long getPageLoadTimeout() {
        return this.getFluentControl().getPageLoadTimeout();
    }

    public Long getImplicitlyWait() {
        return this.getFluentControl().getImplicitlyWait();
    }

    public Long getScriptTimeout() {
        return this.getFluentControl().getScriptTimeout();
    }

    public Long getAwaitAtMost() {
        return this.getFluentControl().getAwaitAtMost();
    }

    public Long getAwaitPollingEvery() {
        return this.getFluentControl().getAwaitPollingEvery();
    }

    public Boolean getEventsEnabled() {
        return this.getFluentControl().getEventsEnabled();
    }

    public String getScreenshotPath() {
        return this.getFluentControl().getScreenshotPath();
    }

    public ConfigurationProperties.TriggerMode getScreenshotMode() {
        return this.getFluentControl().getScreenshotMode();
    }

    public String getHtmlDumpPath() {
        return this.getFluentControl().getHtmlDumpPath();
    }

    public ConfigurationProperties.TriggerMode getHtmlDumpMode() {
        return this.getFluentControl().getHtmlDumpMode();
    }

    public Class<? extends ConfigurationProperties> getConfigurationDefaults() {
        return this.getFluentControl().getConfigurationDefaults();
    }

    public Class<? extends ConfigurationFactory> getConfigurationFactory() {
        return this.getFluentControl().getConfigurationFactory();
    }

    public String getCustomProperty(String propertyName) {
        return this.getFluentControl().getCustomProperty(propertyName);
    }

    public void setWebDriver(String webDriver) {
        this.getFluentControl().setWebDriver(webDriver);
    }

    public void setRemoteUrl(String remoteUrl) {
        this.getFluentControl().setRemoteUrl(remoteUrl);
    }

    public void setCapabilities(Capabilities capabilities) {
        this.getFluentControl().setCapabilities(capabilities);
    }

    public void setConfigurationFactory(Class<? extends ConfigurationFactory> configurationFactory) {
        this.getFluentControl().setConfigurationFactory(configurationFactory);
    }

    public void setDriverLifecycle(ConfigurationProperties.DriverLifecycle driverLifecycle) {
        this.getFluentControl().setDriverLifecycle(driverLifecycle);
    }

    public void setDeleteCookies(Boolean deleteCookies) {
        this.getFluentControl().setDeleteCookies(deleteCookies);
    }

    public void setBaseUrl(String baseUrl) {
        this.getFluentControl().setBaseUrl(baseUrl);
    }

    public void setPageLoadTimeout(Long pageLoadTimeout) {
        this.getFluentControl().setPageLoadTimeout(pageLoadTimeout);
    }

    public void setImplicitlyWait(Long implicitlyWait) {
        this.getFluentControl().setImplicitlyWait(implicitlyWait);
    }

    public void setAwaitAtMost(Long awaitAtMost) {
        this.getFluentControl().setAwaitAtMost(awaitAtMost);
    }

    public void setAwaitPollingEvery(Long awaitPollingEvery) {
        this.getFluentControl().setAwaitPollingEvery(awaitPollingEvery);
    }

    public void setScriptTimeout(Long scriptTimeout) {
        this.getFluentControl().setScriptTimeout(scriptTimeout);
    }

    public void setEventsEnabled(Boolean eventsEnabled) {
        this.getFluentControl().setEventsEnabled(eventsEnabled);
    }

    public void setScreenshotPath(String screenshotPath) {
        this.getFluentControl().setScreenshotPath(screenshotPath);
    }

    public void setScreenshotMode(ConfigurationProperties.TriggerMode screenshotMode) {
        this.getFluentControl().setScreenshotMode(screenshotMode);
    }

    public void setHtmlDumpPath(String htmlDumpPath) {
        this.getFluentControl().setHtmlDumpPath(htmlDumpPath);
    }

    public void setHtmlDumpMode(ConfigurationProperties.TriggerMode htmlDumpMode) {
        this.getFluentControl().setHtmlDumpMode(htmlDumpMode);
    }

    public void setCustomProperty(String key, String value) {
        this.getFluentControl().setCustomProperty(key, value);
    }

    @Override
    public FluentWebElement noHook() {
        return this.getHookControl().noHook();
    }

    @Override
    public FluentWebElement noHook(Class<? extends FluentHook> ... hooks) {
        return this.getHookControl().noHook(hooks);
    }

    @Override
    public FluentWebElement restoreHooks() {
        return this.getHookControl().restoreHooks();
    }

    @Override
    public <O, H extends FluentHook<O>> FluentWebElement withHook(Class<H> hook) {
        return this.getHookControl().withHook(hook);
    }

    @Override
    public <O, H extends FluentHook<O>> FluentWebElement withHook(Class<H> hook, O options) {
        return this.getHookControl().withHook(hook, options);
    }

    @Override
    public <R> R noHook(Function<FluentWebElement, R> function) {
        return this.getHookControl().noHook(function);
    }

    @Override
    public <R> R noHook(Class<? extends FluentHook> hook, Function<FluentWebElement, R> function) {
        return this.getHookControl().noHook(hook, function);
    }

    @Override
    public FluentWebElement noHookInstance() {
        return this.getHookControl().noHookInstance();
    }

    @Override
    public FluentWebElement noHookInstance(Class<? extends FluentHook> ... hooks) {
        return this.getHookControl().noHookInstance(hooks);
    }

    public FluentWebElement scrollIntoView() {
        return this.getJavascriptActions().scrollIntoView();
    }

    public FluentWebElement scrollIntoView(boolean alignWithTop) {
        return this.getJavascriptActions().scrollIntoView(alignWithTop);
    }

    public FluentWebElement scrollToElement() {
        return this.getJavascriptActions().scrollToElement();
    }

    public void scrollCentrallyTo(int y) {
        this.getJavascriptActions().scrollCentrallyTo(y);
    }
}

