/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.conditions;

import com.google.common.base.Predicate;
import org.fluentlenium.core.conditions.AbstractObjectConditions;
import org.fluentlenium.core.conditions.IntegerConditions;
import org.fluentlenium.core.conditions.IntegerConditionsImpl;
import org.fluentlenium.core.conditions.Negation;
import org.fluentlenium.core.conditions.RectangleConditions;
import org.openqa.selenium.Rectangle;

public class RectangleConditionsImpl
extends AbstractObjectConditions<Rectangle>
implements RectangleConditions {
    public RectangleConditionsImpl(Rectangle rectangle) {
        super(rectangle);
    }

    public RectangleConditionsImpl(Rectangle rectangle, boolean negation) {
        super(rectangle, negation);
    }

    protected RectangleConditionsImpl newInstance(boolean negationValue) {
        return new RectangleConditionsImpl((Rectangle)this.object, negationValue);
    }

    @Override
    @Negation
    public RectangleConditionsImpl not() {
        return (RectangleConditionsImpl)super.not();
    }

    @Override
    public boolean x(final int x) {
        return this.verify(new Predicate<Rectangle>(){

            public boolean apply(Rectangle input) {
                return input.getX() == x;
            }
        });
    }

    @Override
    public IntegerConditions x() {
        return new IntegerConditionsImpl(((Rectangle)this.object).getX(), this.negation);
    }

    @Override
    public boolean y(final int y) {
        return this.verify(new Predicate<Rectangle>(){

            public boolean apply(Rectangle input) {
                return input.getY() == y;
            }
        });
    }

    @Override
    public IntegerConditions y() {
        return new IntegerConditionsImpl(((Rectangle)this.object).getY(), this.negation);
    }

    @Override
    public boolean position(final int x, final int y) {
        return this.verify(new Predicate<Rectangle>(){

            public boolean apply(Rectangle input) {
                return input.getX() == x && input.getY() == y;
            }
        });
    }

    @Override
    public boolean width(final int width) {
        return this.verify(new Predicate<Rectangle>(){

            public boolean apply(Rectangle input) {
                return input.getWidth() == width;
            }
        });
    }

    @Override
    public IntegerConditions width() {
        return new IntegerConditionsImpl(((Rectangle)this.object).getWidth(), this.negation);
    }

    @Override
    public boolean height(final int height) {
        return this.verify(new Predicate<Rectangle>(){

            public boolean apply(Rectangle input) {
                return ((Rectangle)RectangleConditionsImpl.this.object).getHeight() == height;
            }
        });
    }

    @Override
    public IntegerConditions height() {
        return new IntegerConditionsImpl(((Rectangle)this.object).getHeight(), this.negation);
    }

    @Override
    public boolean dimension(final int width, final int height) {
        return this.verify(new Predicate<Rectangle>(){

            public boolean apply(Rectangle input) {
                return input.getWidth() == width && input.getHeight() == height;
            }
        });
    }

    @Override
    public boolean positionAndDimension(final int x, final int y, final int width, final int height) {
        return this.verify(new Predicate<Rectangle>(){

            public boolean apply(Rectangle input) {
                return input.getX() == x && input.getY() == y && input.getWidth() == width && input.getHeight() == height;
            }
        });
    }
}

