/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.conditions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.List;
import org.fluentlenium.core.conditions.Conditions;
import org.fluentlenium.core.conditions.ConditionsObject;
import org.fluentlenium.core.conditions.ListConditionsElements;
import org.fluentlenium.core.domain.FluentWebElement;

public class BaseObjectListConditions<T, C extends Conditions<T>>
implements ConditionsObject<List<T>> {
    protected Conditions<FluentWebElement> conditions;
    protected final Function<FluentWebElement, T> objectGetter;
    protected final Function<FluentWebElement, C> conditionsGetter;

    public BaseObjectListConditions(Conditions<FluentWebElement> conditions, Function<FluentWebElement, T> objectGetter, Function<FluentWebElement, C> conditionsGetter) {
        this.conditions = conditions;
        this.objectGetter = objectGetter;
        this.conditionsGetter = conditionsGetter;
    }

    @Override
    public List<T> getActualObject() {
        if (this.conditions instanceof ListConditionsElements) {
            List<? extends FluentWebElement> elements = ((ListConditionsElements)((Object)this.conditions)).getActualElements();
            return new ArrayList(Collections2.transform(elements, this.objectGetter));
        }
        return new ArrayList();
    }

    public boolean verify(final Predicate<T> predicate) {
        return this.conditions.verify(new Predicate<FluentWebElement>(){

            public boolean apply(FluentWebElement input) {
                return predicate.apply(BaseObjectListConditions.this.objectGetter.apply((Object)input));
            }
        });
    }
}

