/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.conditions;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import org.fluentlenium.core.FluentDriver;
import org.fluentlenium.core.conditions.AbstractFluentListConditions;
import org.fluentlenium.core.domain.FluentWebElement;

public class AtLeastOneElementConditions
extends AbstractFluentListConditions {
    public AtLeastOneElementConditions(List<? extends FluentWebElement> elements) {
        super(elements);
    }

    @Override
    public AtLeastOneElementConditions not() {
        AtLeastOneElementConditions negatedConditions = new AtLeastOneElementConditions(this.getElements());
        negatedConditions.setNegation(!this.isNegation());
        return negatedConditions;
    }

    @Override
    public boolean verify(Predicate<FluentWebElement> predicate, boolean defaultValue) {
        if (this.isNegation()) {
            predicate = Predicates.not(predicate);
            defaultValue = !defaultValue;
        }
        return this.buildAtLeastOnePredicate((Predicate<FluentWebElement>)predicate, defaultValue).apply(null);
    }

    protected Predicate<FluentDriver> buildAtLeastOnePredicate(final Predicate<FluentWebElement> predicate, final boolean defaultValue) {
        Predicate<FluentDriver> untilPredicate = new Predicate<FluentDriver>(){

            public boolean apply(FluentDriver fluent) {
                if (!AtLeastOneElementConditions.this.getElements().isEmpty()) {
                    for (FluentWebElement fluentWebElement : AtLeastOneElementConditions.this.getElements()) {
                        if (!predicate.apply((Object)fluentWebElement)) continue;
                        return true;
                    }
                    return false;
                }
                return defaultValue;
            }
        };
        return untilPredicate;
    }
}

