/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.components;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.components.AbstractComponentInstantiator;
import org.fluentlenium.core.components.ComponentException;
import org.fluentlenium.core.components.ComponentInstantiator;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.WebElement;

public class DefaultComponentInstantiator
extends AbstractComponentInstantiator {
    private final FluentControl control;
    private final ComponentInstantiator instantiator;

    public DefaultComponentInstantiator(FluentControl control) {
        this.control = control;
        this.instantiator = this;
    }

    public DefaultComponentInstantiator(FluentControl control, ComponentInstantiator instantiator) {
        this.control = control;
        this.instantiator = instantiator;
    }

    @Override
    public boolean isComponentClass(Class<?> componentClass) {
        try {
            ReflectionUtils.getConstructorOptional(1, componentClass, WebElement.class, FluentControl.class, ComponentInstantiator.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public boolean isComponentListClass(Class<? extends List<?>> componentListClass) {
        try {
            ReflectionUtils.getConstructorOptional(1, componentListClass, Class.class, List.class, FluentControl.class, ComponentInstantiator.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public <T> T newComponent(Class<T> componentClass, WebElement element) {
        try {
            return ReflectionUtils.newInstanceOptionalArgs(1, componentClass, element, this.control, this.instantiator);
        }
        catch (NoSuchMethodException e) {
            throw new ComponentException(componentClass.getName() + " is not a valid component class.", e);
        }
        catch (IllegalAccessException e) {
            throw new ComponentException(componentClass.getName() + " can't be instantiated.", e);
        }
        catch (InvocationTargetException e) {
            throw new ComponentException(componentClass.getName() + " can't be instantiated.", e);
        }
        catch (InstantiationException e) {
            throw new ComponentException(componentClass.getName() + " can't be instantiated.", e);
        }
    }

    @Override
    public <L extends List<T>, T> L newComponentList(Class<L> listClass, Class<T> componentClass, List<T> componentsList) {
        try {
            return (L)((List)ReflectionUtils.newInstanceOptionalArgs(1, listClass, componentClass, componentsList, this.control, this.instantiator));
        }
        catch (NoSuchMethodException e) {
            throw new ComponentException(listClass.getName() + " is not a valid component list class.", e);
        }
        catch (IllegalAccessException e) {
            throw new ComponentException(listClass.getName() + " can't be instantiated.", e);
        }
        catch (InvocationTargetException e) {
            throw new ComponentException(listClass.getName() + " can't be instantiated.", e);
        }
        catch (InstantiationException e) {
            throw new ComponentException(listClass.getName() + " can't be instantiated.", e);
        }
    }
}

