/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.action;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;

public class MouseElementActions {
    private WebDriver driver;
    private Keyboard keyboard;
    private Mouse mouse;
    private final WebElement element;

    public MouseElementActions(WebDriver driver, WebElement element) {
        this.driver = driver;
        this.element = element;
    }

    public MouseElementActions(Keyboard keyboard, Mouse mouse, WebElement element) {
        this.keyboard = keyboard;
        this.mouse = mouse;
        this.element = element;
    }

    private Actions actions() {
        if (this.driver == null) {
            return new Actions(this.keyboard, this.mouse);
        }
        return new Actions(this.driver);
    }

    public Mouse basic() {
        if (this.mouse == null) {
            return ((HasInputDevices)this.driver).getMouse();
        }
        return this.mouse;
    }

    public MouseElementActions clickAndHold() {
        this.actions().clickAndHold(this.element).perform();
        return this;
    }

    public MouseElementActions release() {
        this.actions().release(this.element).perform();
        return this;
    }

    public MouseElementActions click() {
        this.actions().click(this.element).perform();
        return this;
    }

    public MouseElementActions doubleClick() {
        this.actions().doubleClick(this.element).perform();
        return this;
    }

    public MouseElementActions moveToElement() {
        this.actions().moveToElement(this.element).perform();
        return this;
    }

    public MouseElementActions moveToElement(int xOffset, int yOffset) {
        this.actions().moveToElement(this.element, xOffset, yOffset).perform();
        return this;
    }

    public MouseElementActions contextClick() {
        this.actions().contextClick(this.element).perform();
        return this;
    }

    public MouseElementActions dragAndDropFrom(WebElement source) {
        this.actions().dragAndDrop(source, this.element).perform();
        return this;
    }

    public MouseElementActions dragAndDropTo(WebElement target) {
        this.actions().dragAndDrop(this.element, target).perform();
        return this;
    }

    public MouseElementActions dragAndDropBy(int xOffset, int yOffset) {
        this.actions().dragAndDropBy(this.element, xOffset, yOffset).perform();
        return this;
    }
}

