/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.action;

import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;

public class KeyboardElementActions {
    private WebDriver driver;
    private Keyboard keyboard;
    private Mouse mouse;
    private final WebElement element;

    public KeyboardElementActions(WebDriver driver, WebElement element) {
        this.driver = driver;
        this.element = element;
    }

    public KeyboardElementActions(Keyboard keyboard, Mouse mouse, WebElement element) {
        this.keyboard = keyboard;
        this.mouse = mouse;
        this.element = element;
    }

    protected Actions actions() {
        if (this.driver == null) {
            return new Actions(this.keyboard, this.mouse);
        }
        return new Actions(this.driver);
    }

    public Keyboard basic() {
        if (this.keyboard == null) {
            return ((HasInputDevices)this.driver).getKeyboard();
        }
        return this.keyboard;
    }

    public KeyboardElementActions keyDown(Keys theKey) {
        this.actions().keyDown(this.element, theKey).perform();
        return this;
    }

    public KeyboardElementActions keyUp(Keys theKey) {
        this.actions().keyUp(this.element, theKey).perform();
        return this;
    }

    public KeyboardElementActions sendKeys(CharSequence ... keysToSend) {
        this.actions().sendKeys(this.element, keysToSend).perform();
        return this;
    }
}

