/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.configuration;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.fluentlenium.configuration.BaseConfiguration;
import org.fluentlenium.configuration.CapabilitiesFactory;
import org.fluentlenium.configuration.CapabilitiesRegistry;
import org.fluentlenium.configuration.ConfigurationDefaults;
import org.fluentlenium.configuration.ConfigurationException;
import org.fluentlenium.configuration.ConfigurationFactory;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.fluentlenium.configuration.PropertiesBackend;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.JsonException;
import org.openqa.selenium.remote.JsonToBeanConverter;

public class PropertiesBackendConfiguration
extends BaseConfiguration
implements ConfigurationProperties {
    public static final String PROPERTIES_PREFIX = "fluentlenium.";
    private final String[] prefixes;
    private final JsonToBeanConverter jsonConverter = new JsonToBeanConverter();
    private PropertiesBackend propertiesBackend;

    protected PropertiesBackendConfiguration(PropertiesBackend propertiesReader) {
        this(propertiesReader, PROPERTIES_PREFIX);
    }

    protected PropertiesBackendConfiguration(PropertiesBackend propertiesReader, String ... prefixes) {
        if (prefixes.length == 0) {
            throw new IllegalArgumentException("Prefixes should be defined");
        }
        this.propertiesBackend = propertiesReader;
        this.prefixes = prefixes;
    }

    PropertiesBackend getPropertiesBackend() {
        return this.propertiesBackend;
    }

    void setPropertiesBackend(PropertiesBackend propertiesBackend) {
        this.propertiesBackend = propertiesBackend;
    }

    protected String getPropertyImpl(String propertyName) {
        return this.propertiesBackend.getProperty(propertyName);
    }

    private String getProperty(String propertyName) {
        for (String prefix : this.prefixes) {
            String property = this.getPropertyImpl(prefix + propertyName);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    private boolean isValidProperty(String property) {
        return !Strings.isNullOrEmpty((String)property) && !"null".equalsIgnoreCase(property);
    }

    private String getStringProperty(String propertyName) {
        String property = this.getProperty(propertyName);
        if (!this.isValidProperty(property)) {
            return null;
        }
        return property;
    }

    private Long getLongProperty(String propertyName) {
        String property = this.getProperty(propertyName);
        if (!this.isValidProperty(property)) {
            return null;
        }
        try {
            return Long.parseLong(property);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Boolean getBooleanProperty(String propertyName) {
        String property = this.getProperty(propertyName);
        if (!this.isValidProperty(property)) {
            return null;
        }
        return Boolean.parseBoolean(property);
    }

    private <T extends Enum<T>> T getEnumProperty(Class<T> enumClass, String propertyName) {
        String property = this.getProperty(propertyName);
        if (!this.isValidProperty(property)) {
            return null;
        }
        if ("DEFAULT".equalsIgnoreCase(propertyName)) {
            return null;
        }
        return Enum.valueOf(enumClass, property);
    }

    private <T> Class<T> getClassProperty(Class<T> clazz, String propertyName) {
        String property = this.getProperty(propertyName);
        if (!this.isValidProperty(property)) {
            return null;
        }
        try {
            Class<?> propertyClass = Class.forName(property);
            if (clazz.isAssignableFrom(propertyClass)) {
                return propertyClass;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    protected URL newURL(String url) throws MalformedURLException {
        return new URL(url);
    }

    private Capabilities getCapabilitiesProperty(String propertyName) {
        String property = this.getProperty(propertyName);
        if (!this.isValidProperty(property)) {
            return null;
        }
        try {
            URL url = this.newURL(property);
            try {
                property = IOUtils.toString((URL)url, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new ConfigurationException("Can't read Capabilities defined at " + url, e);
            }
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        CapabilitiesFactory factory = CapabilitiesRegistry.INSTANCE.get(property);
        if (factory != null) {
            return factory.newCapabilities(this.getGlobalConfiguration());
        }
        try {
            return (Capabilities)this.jsonConverter.convert(DesiredCapabilities.class, (Object)property);
        }
        catch (JsonException e) {
            throw new ConfigurationException("Can't convert JSON Capabilities to Object.", e);
        }
    }

    @Override
    public Class<? extends ConfigurationFactory> getConfigurationFactory() {
        return this.getClassProperty(ConfigurationFactory.class, "configurationFactory");
    }

    @Override
    public Class<? extends ConfigurationProperties> getConfigurationDefaults() {
        return this.getClassProperty(ConfigurationDefaults.class, "configurationDefaults");
    }

    @Override
    public String getWebDriver() {
        return this.getStringProperty("webDriver");
    }

    @Override
    public String getRemoteUrl() {
        return this.getStringProperty("remoteUrl");
    }

    @Override
    public Capabilities getCapabilities() {
        return this.getCapabilitiesProperty("capabilities");
    }

    @Override
    public ConfigurationProperties.DriverLifecycle getDriverLifecycle() {
        return this.getEnumProperty(ConfigurationProperties.DriverLifecycle.class, this.getStringProperty("driverLifecycle"));
    }

    @Override
    public Boolean getDeleteCookies() {
        return this.getBooleanProperty("deleteCookies");
    }

    @Override
    public String getBaseUrl() {
        return this.getStringProperty("baseUrl");
    }

    @Override
    public Boolean getEventsEnabled() {
        return this.getBooleanProperty("eventsEnabled");
    }

    @Override
    public Long getPageLoadTimeout() {
        return this.getLongProperty("pageLoadTimeout");
    }

    @Override
    public Long getImplicitlyWait() {
        return this.getLongProperty("implicitlyWait");
    }

    @Override
    public Long getScriptTimeout() {
        return this.getLongProperty("scriptTimeout");
    }

    @Override
    public Long getAwaitAtMost() {
        return this.getLongProperty("awaitAtMost");
    }

    @Override
    public Long getAwaitPollingEvery() {
        return this.getLongProperty("awaitPollingEvery");
    }

    @Override
    public String getScreenshotPath() {
        return this.getStringProperty("screenshotPath");
    }

    @Override
    public String getHtmlDumpPath() {
        return this.getStringProperty("htmlDumpPath");
    }

    @Override
    public ConfigurationProperties.TriggerMode getScreenshotMode() {
        return this.getEnumProperty(ConfigurationProperties.TriggerMode.class, "screenshotMode");
    }

    @Override
    public ConfigurationProperties.TriggerMode getHtmlDumpMode() {
        return this.getEnumProperty(ConfigurationProperties.TriggerMode.class, "htmlDumpMode");
    }

    @Override
    public String getCustomProperty(String propertyName) {
        return this.getStringProperty(propertyName);
    }
}

