/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.configuration;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.fluentlenium.configuration.ConfigurationException;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.fluentlenium.configuration.DefaultFactory;
import org.fluentlenium.configuration.FactoryPriority;
import org.fluentlenium.configuration.ReflectiveWebDriverFactory;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class DefaultWebDriverFactories {

    @DefaultFactory
    public static class HtmlUnitWebDriverFactory
    extends ReflectiveWebDriverFactory {
        public HtmlUnitWebDriverFactory() {
            super("htmlunit", "org.openqa.selenium.htmlunit.HtmlUnitDriver", new Object[0]);
        }

        @Override
        protected DesiredCapabilities newDefaultCapabilities() {
            DesiredCapabilities desiredCapabilities = new DesiredCapabilities();
            desiredCapabilities.setJavascriptEnabled(true);
            return desiredCapabilities;
        }
    }

    @DefaultFactory
    public static class RemoteWebDriverFactory
    extends ReflectiveWebDriverFactory {
        public RemoteWebDriverFactory() {
            super("remote", RemoteWebDriver.class, new Object[0]);
        }

        @Override
        protected WebDriver newInstance(Class<? extends WebDriver> webDriverClass, ConfigurationProperties configuration, Object ... args) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
            String remoteUrl;
            URL url = null;
            if (configuration != null && (remoteUrl = configuration.getRemoteUrl()) != null) {
                try {
                    url = new URL(remoteUrl);
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException("remoteUrl configuration property is not a valid URL.", e);
                }
            }
            return this.newRemoteWebDriver(url, args.length > 0 ? args[0] : new DesiredCapabilities());
        }

        protected WebDriver newRemoteWebDriver(Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
            WebDriver webDriver = (WebDriver)ReflectionUtils.getConstructor(this.webDriverClass, URL.class, Capabilities.class).newInstance(args);
            return new Augmenter().augment(webDriver);
        }
    }

    @FactoryPriority(value=8)
    @DefaultFactory
    public static class PhantomJSWebDriverFactory
    extends ReflectiveWebDriverFactory {
        public PhantomJSWebDriverFactory() {
            super("phantomjs", "org.openqa.selenium.phantomjs.PhantomJSDriver", new Object[0]);
        }
    }

    @FactoryPriority(value=16)
    @DefaultFactory
    public static class SafariWebDriverFactory
    extends ReflectiveWebDriverFactory {
        public SafariWebDriverFactory() {
            super("safari", "org.openqa.selenium.safari.SafariDriver", new Object[0]);
        }
    }

    @FactoryPriority(value=31)
    @DefaultFactory
    public static class EdgeWebDriverFactory
    extends ReflectiveWebDriverFactory {
        public EdgeWebDriverFactory() {
            super("edge", "org.openqa.selenium.edge.EdgeDriver", new Object[0]);
        }
    }

    @FactoryPriority(value=32)
    @DefaultFactory
    public static class InternetExplorerWebDriverFactory
    extends ReflectiveWebDriverFactory {
        public InternetExplorerWebDriverFactory() {
            super("ie", "org.openqa.selenium.ie.InternetExplorerDriver", new Object[0]);
        }
    }

    @FactoryPriority(value=64)
    @DefaultFactory
    public static class ChromeWebDriverFactory
    extends ReflectiveWebDriverFactory {
        public ChromeWebDriverFactory() {
            super("chrome", "org.openqa.selenium.chrome.ChromeDriver", new Object[0]);
        }
    }

    @FactoryPriority(value=128)
    @DefaultFactory
    public static class FirefoxWebDriverFactory
    extends ReflectiveWebDriverFactory {
        public FirefoxWebDriverFactory() {
            super("firefox", "org.openqa.selenium.firefox.FirefoxDriver", new Object[0]);
        }
    }
}

