/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.fluentlenium.core.Fluent;
import org.fluentlenium.core.FluentThread;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.filter.FilterConstructor;
import org.fluentlenium.core.filter.FilterType;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.wait.FluentSizeBuilder;
import org.fluentlenium.core.wait.FluentWaitBuilder;
import org.fluentlenium.core.wait.WaitMessage;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.FluentWait;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentWaitMatcher {
    private List<Filter> filters = new ArrayList<Filter>();
    private Search search;
    private String selector;
    private FluentWait wait;

    public FluentWaitMatcher(Search search, FluentWait fluentWait, String selector) {
        this.selector = selector;
        this.wait = fluentWait;
        this.search = search;
    }

    public Fluent hasAttribute(final String attribute, final String value) {
        Predicate<WebDriver> hasAttribute = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                if (FluentWaitMatcher.this.filters.size() > 0) {
                    return FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, FluentWaitMatcher.this.filters.toArray(new Filter[FluentWaitMatcher.this.filters.size()])).getAttributes(attribute).contains(value);
                }
                return FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, new Filter[0]).getAttributes(attribute).contains(value);
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)hasAttribute, this.filters, WaitMessage.hasAttributeMessage(this.selector, attribute, value));
        return FluentThread.get();
    }

    static void until(FluentWait wait, Predicate present, List<Filter> filters, String defaultMessage) {
        StringBuilder message = new StringBuilder(defaultMessage);
        if (filters != null && !filters.isEmpty()) {
            for (Filter filter : filters) {
                message.append(filter.toString());
            }
            message.append(" Filters : ");
        }
        wait.withMessage(message.toString()).until(present);
    }

    public Fluent hasId(final String value) {
        Predicate<WebDriver> hasId = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                if (FluentWaitMatcher.this.filters.size() > 0) {
                    return FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, FluentWaitMatcher.this.filters.toArray(new Filter[FluentWaitMatcher.this.filters.size()])).getIds().contains(value);
                }
                return FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, new Filter[0]).getIds().contains(value);
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)hasId, this.filters, WaitMessage.hasIdMessage(this.selector, value));
        return FluentThread.get();
    }

    public Fluent hasName(final String value) {
        Predicate<WebDriver> hasName = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                if (FluentWaitMatcher.this.filters.size() > 0) {
                    return FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, FluentWaitMatcher.this.filters.toArray(new Filter[FluentWaitMatcher.this.filters.size()])).getNames().contains(value);
                }
                return FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, new Filter[0]).getNames().contains(value);
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)hasName, this.filters, WaitMessage.hasNameMessage(this.selector, value));
        return FluentThread.get();
    }

    public FluentSizeBuilder hasSize() {
        return new FluentSizeBuilder(this.search, this.wait, this.selector, this.filters);
    }

    public Fluent hasSize(final int size) {
        Predicate<WebDriver> hasSize = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                int size1 = FluentWaitMatcher.this.filters.size() > 0 ? FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, FluentWaitMatcher.this.filters.toArray(new Filter[FluentWaitMatcher.this.filters.size()])).size() : FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, new Filter[0]).size();
                return size1 == size;
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)hasSize, this.filters, WaitMessage.hasSizeMessage(this.selector, size));
        return FluentThread.get();
    }

    public Fluent containsText(final String value) {
        Predicate<WebDriver> hasText = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                List<String> texts = FluentWaitMatcher.this.filters.size() > 0 ? FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, FluentWaitMatcher.this.filters.toArray(new Filter[FluentWaitMatcher.this.filters.size()])).getTexts() : FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, new Filter[0]).getTexts();
                if (texts != null) {
                    for (String text : texts) {
                        if (!text.contains(value)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)hasText, this.filters, WaitMessage.hasTextMessage(this.selector, value));
        return FluentThread.get();
    }

    public Fluent hasText(final String value) {
        Predicate<WebDriver> hasText = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                if (FluentWaitMatcher.this.filters.size() > 0) {
                    return FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, FluentWaitMatcher.this.filters.toArray(new Filter[FluentWaitMatcher.this.filters.size()])).getTexts().contains(value);
                }
                return FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, new Filter[0]).getTexts().contains(value);
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)hasText, this.filters, WaitMessage.hasTextMessage(this.selector, value));
        return FluentThread.get();
    }

    public Fluent isPresent() {
        Predicate<WebDriver> isPresent = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                int size = FluentWaitMatcher.this.filters.size() > 0 ? FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, FluentWaitMatcher.this.filters.toArray(new Filter[FluentWaitMatcher.this.filters.size()])).size() : FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, new Filter[0]).size();
                return size > 0;
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)isPresent, this.filters, WaitMessage.isPresentMessage(this.selector));
        return FluentThread.get();
    }

    public Fluent isNotPresent() {
        Predicate<WebDriver> isNotPresent = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                int size = FluentWaitMatcher.this.filters.size() > 0 ? FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, FluentWaitMatcher.this.filters.toArray(new Filter[FluentWaitMatcher.this.filters.size()])).size() : FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, new Filter[0]).size();
                return size == 0;
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)isNotPresent, this.filters, WaitMessage.isNotPresentMessage(this.selector));
        return FluentThread.get();
    }

    public Fluent areDisplayed() {
        Predicate<WebDriver> isVisible = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                if (FluentWaitMatcher.this.filters.size() > 0) {
                    FluentList<FluentWebElement> fluentWebElements = FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, FluentWaitMatcher.this.filters.toArray(new Filter[FluentWaitMatcher.this.filters.size()]));
                    if (fluentWebElements.size() > 0) {
                        for (FluentWebElement fluentWebElement : fluentWebElements) {
                            if (fluentWebElement.isDisplayed()) continue;
                            return false;
                        }
                        return true;
                    }
                } else {
                    FluentList<FluentWebElement> fluentWebElements = FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, new Filter[0]);
                    if (fluentWebElements.size() > 0) {
                        for (FluentWebElement fluentWebElement : fluentWebElements) {
                            if (fluentWebElement.isDisplayed()) continue;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)isVisible, this.filters, WaitMessage.isDisplayedMessage(this.selector));
        return FluentThread.get();
    }

    public Fluent areEnabled() {
        Predicate<WebDriver> isEnabled = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                if (FluentWaitMatcher.this.filters.size() > 0) {
                    FluentList<FluentWebElement> fluentWebElements = FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, FluentWaitMatcher.this.filters.toArray(new Filter[FluentWaitMatcher.this.filters.size()]));
                    if (fluentWebElements.size() > 0) {
                        for (FluentWebElement fluentWebElement : fluentWebElements) {
                            if (fluentWebElement.isEnabled()) continue;
                            return false;
                        }
                        return true;
                    }
                } else {
                    FluentList<FluentWebElement> fluentWebElements = FluentWaitMatcher.this.search.find(FluentWaitMatcher.this.selector, new Filter[0]);
                    if (fluentWebElements.size() > 0) {
                        for (FluentWebElement fluentWebElement : fluentWebElements) {
                            if (fluentWebElement.isEnabled()) continue;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)isEnabled, this.filters, WaitMessage.isEnabledMessage(this.selector));
        return FluentThread.get();
    }

    public FluentWaitBuilder with(String attribute) {
        return new FluentWaitBuilder(this, attribute);
    }

    public FluentWaitBuilder withId() {
        return new FluentWaitBuilder(this, FilterType.ID);
    }

    public FluentWaitMatcher withId(String value) {
        this.filters.add(FilterConstructor.withId(value));
        return this;
    }

    public FluentWaitBuilder withName() {
        return new FluentWaitBuilder(this, FilterType.NAME);
    }

    public FluentWaitMatcher withName(String value) {
        this.filters.add(FilterConstructor.withName(value));
        return this;
    }

    public FluentWaitBuilder withText() {
        return new FluentWaitBuilder(this, FilterType.TEXT);
    }

    public FluentWaitMatcher withText(String value) {
        this.filters.add(FilterConstructor.withText(value));
        return this;
    }

    void addFilter(Filter filter) {
        this.filters.add(filter);
    }
}

