/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.fluentlenium.core.Fluent;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.wait.FluentWaitMatcher;
import org.fluentlenium.core.wait.FluentWaitPageMatcher;
import org.openqa.selenium.Beta;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.Wait;

public class FluentWait
implements Wait<Fluent> {
    private final org.openqa.selenium.support.ui.FluentWait<Fluent> wait;
    private final Search search;
    private final WebDriver driver;
    private boolean useDefaultException;

    public org.openqa.selenium.support.ui.FluentWait getWait() {
        return this.wait;
    }

    public FluentWait(Fluent fluent, Search search) {
        this.wait = new org.openqa.selenium.support.ui.FluentWait((Object)fluent);
        this.search = search;
        this.driver = fluent.getDriver();
        this.useDefaultException = true;
    }

    public FluentWait atMost(long duration, TimeUnit unit) {
        this.wait.withTimeout(duration, unit);
        return this;
    }

    public FluentWait atMost(long timeInMillis) {
        this.wait.withTimeout(timeInMillis, TimeUnit.MILLISECONDS);
        return this;
    }

    public FluentWait pollingEvery(long duration, TimeUnit unit) {
        this.wait.pollingEvery(duration, unit);
        return this;
    }

    public FluentWait ignoreAll(Collection<Class<? extends Throwable>> types) {
        this.wait.ignoreAll(types);
        return this;
    }

    public FluentWait ignoring(Class<? extends RuntimeException> exceptionType) {
        this.wait.ignoring(exceptionType);
        return this;
    }

    public FluentWait ignoring(Class<? extends RuntimeException> firstType, Class<? extends RuntimeException> secondType) {
        this.wait.ignoring(firstType, secondType);
        return this;
    }

    public FluentWait until(Predicate<Fluent> isTrue) {
        this.updateWaitWithDefaultExceptions();
        this.wait.until(isTrue);
        return this;
    }

    public FluentWait withMessage(String message) {
        this.wait.withMessage(message);
        return this;
    }

    @Beta
    public FluentWait withNoDefaultsException() {
        this.useDefaultException = false;
        return this;
    }

    public FluentWaitMatcher until(String string) {
        this.updateWaitWithDefaultExceptions();
        return new FluentWaitMatcher(this.search, this, string);
    }

    public FluentWaitPageMatcher untilPage() {
        this.updateWaitWithDefaultExceptions();
        return new FluentWaitPageMatcher(this, this.driver);
    }

    public FluentWaitPageMatcher untilPage(FluentPage page) {
        this.updateWaitWithDefaultExceptions();
        return new FluentWaitPageMatcher(this, this.driver, page);
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public <T> T until(Function<? super Fluent, T> isTrue) {
        this.updateWaitWithDefaultExceptions();
        return (T)this.wait.until(isTrue);
    }

    private void updateWaitWithDefaultExceptions() {
        if (this.useDefaultException) {
            this.wait.ignoring(StaleElementReferenceException.class);
        }
    }
}

