/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.search;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.filter.FilterPredicate;
import org.fluentlenium.core.search.SearchActions;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class Search
implements SearchActions<FluentWebElement> {
    private final SearchContext searchContext;

    public Search(SearchContext context) {
        this.searchContext = context;
    }

    @Override
    public FluentList<FluentWebElement> find(String name, Filter ... filters) {
        StringBuilder sb = new StringBuilder(name);
        ArrayList<Filter> postFilterSelector = new ArrayList<Filter>();
        if (filters != null && filters.length > 0) {
            for (Filter selector : filters) {
                if (selector.isPreFilter()) {
                    sb.append(selector.toString());
                    continue;
                }
                postFilterSelector.add(selector);
            }
        }
        Collection<FluentWebElement> postFiltered = this.select(sb.toString());
        for (Filter selector : postFilterSelector) {
            postFiltered = Collections2.filter(postFiltered, (Predicate)new FilterPredicate(selector));
        }
        return new FluentList<FluentWebElement>(postFiltered);
    }

    private List<FluentWebElement> select(String cssSelector) {
        return Lists.transform((List)this.searchContext.findElements(By.cssSelector((String)cssSelector)), (Function)new Function<WebElement, FluentWebElement>(){

            public FluentWebElement apply(WebElement webElement) {
                return new FluentWebElement(webElement);
            }
        });
    }

    @Override
    public FluentWebElement find(String name, Integer number, Filter ... filters) {
        FluentList<FluentWebElement> listFiltered = this.find(name, filters);
        if (number >= listFiltered.size()) {
            throw new NoSuchElementException("No such element with position :" + number + ". Number of elements available :" + listFiltered.size());
        }
        return (FluentWebElement)listFiltered.get(number);
    }

    @Override
    public FluentWebElement findFirst(String name, Filter ... filters) {
        FluentList<FluentWebElement> fluentList = this.find(name, filters);
        return fluentList.first();
    }
}

