/*
 * Decompiled with CFR 0.152.
 */
package org.fluentd.logger;

import java.util.HashMap;
import java.util.Map;
import org.fluentd.logger.FluentLoggerFactory;
import org.fluentd.logger.errorhandler.ErrorHandler;
import org.fluentd.logger.sender.Reconnector;
import org.fluentd.logger.sender.Sender;

public class FluentLogger {
    private static FluentLoggerFactory factory = new FluentLoggerFactory();
    protected String tagPrefix;
    protected Sender sender;

    public static FluentLogger getLogger(String tagPrefix) {
        return factory.getLogger(tagPrefix, "localhost", 24224);
    }

    public static FluentLogger getLogger(String tagPrefix, String host, int port) {
        return factory.getLogger(tagPrefix, host, port, 3000, 0x100000);
    }

    public static synchronized FluentLogger getLogger(String tagPrefix, String host, int port, int timeout, int bufferCapacity) {
        return factory.getLogger(tagPrefix, host, port, timeout, bufferCapacity);
    }

    public static synchronized FluentLogger getLogger(String tagPrefix, String host, int port, int timeout, int bufferCapacity, Reconnector reconnector) {
        return factory.getLogger(tagPrefix, host, port, timeout, bufferCapacity, reconnector);
    }

    static Map<FluentLogger, String> getLoggers() {
        return factory.getLoggers();
    }

    public static synchronized void closeAll() {
        factory.closeAll();
    }

    public static synchronized void flushAll() {
        factory.flushAll();
    }

    protected FluentLogger() {
    }

    protected FluentLogger(String tagPrefix, Sender sender) {
        this.tagPrefix = tagPrefix;
        this.sender = sender;
    }

    public boolean log(String tag, String key, Object value) {
        return this.log(tag, key, value, 0L);
    }

    public boolean log(String tag, String key, Object value, long timestamp) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(key, value);
        return this.log(tag, data, timestamp);
    }

    public boolean log(String tag, Map<String, Object> data) {
        return this.log(tag, data, 0L);
    }

    public boolean log(String tag, Map<String, Object> data, long timestamp) {
        String concatTag = null;
        concatTag = this.tagPrefix == null || this.tagPrefix.length() == 0 ? tag : this.tagPrefix + "." + tag;
        if (timestamp != 0L) {
            return this.sender.emit(concatTag, timestamp, data);
        }
        return this.sender.emit(concatTag, data);
    }

    public void flush() {
        this.sender.flush();
    }

    public void close() {
        if (this.sender != null) {
            this.sender.flush();
            this.sender.close();
            this.sender = null;
        }
        factory.purgeLogger(this);
    }

    public String getName() {
        return String.format("%s_%s", this.tagPrefix, this.sender.getName());
    }

    public String toString() {
        return String.format("%s{tagPrefix=%s,sender=%s}", this.getClass().getName(), this.tagPrefix, this.sender.toString());
    }

    public void finalize() {
        if (this.sender != null) {
            this.sender.close();
        }
    }

    public boolean isConnected() {
        return this.sender != null && this.sender.isConnected();
    }

    public synchronized void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException("errorHandler is null");
        }
        if (this.sender != null) {
            this.sender.setErrorHandler(errorHandler);
        }
    }

    public synchronized void removeErrorHandler() {
        if (this.sender != null) {
            this.sender.removeErrorHandler();
        }
    }

    public Sender getSender() {
        return this.sender;
    }
}

