/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.persistence.entity;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.AbstractServiceConfiguration;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.common.engine.impl.persistence.entity.AbstractServiceEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.HistoricVariableInstanceQueryImpl;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntityManager;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.variable.service.impl.persistence.entity.data.HistoricVariableInstanceDataManager;

public class HistoricVariableInstanceEntityManagerImpl
extends AbstractServiceEngineEntityManager<VariableServiceConfiguration, HistoricVariableInstanceEntity, HistoricVariableInstanceDataManager>
implements HistoricVariableInstanceEntityManager {
    public HistoricVariableInstanceEntityManagerImpl(VariableServiceConfiguration variableServiceConfiguration, HistoricVariableInstanceDataManager historicVariableInstanceDataManager) {
        super((AbstractServiceConfiguration)variableServiceConfiguration, variableServiceConfiguration.getEngineName(), (DataManager)historicVariableInstanceDataManager);
    }

    @Override
    public HistoricVariableInstanceEntity create(VariableInstanceEntity variableInstance, Date createTime) {
        HistoricVariableInstanceEntity historicVariableInstance = (HistoricVariableInstanceEntity)((HistoricVariableInstanceDataManager)this.dataManager).create();
        historicVariableInstance.setId(variableInstance.getId());
        historicVariableInstance.setProcessInstanceId(variableInstance.getProcessInstanceId());
        historicVariableInstance.setExecutionId(variableInstance.getExecutionId());
        historicVariableInstance.setTaskId(variableInstance.getTaskId());
        historicVariableInstance.setRevision(variableInstance.getRevision());
        historicVariableInstance.setName(variableInstance.getName());
        historicVariableInstance.setVariableType(variableInstance.getType());
        historicVariableInstance.setScopeId(variableInstance.getScopeId());
        historicVariableInstance.setSubScopeId(variableInstance.getSubScopeId());
        historicVariableInstance.setScopeType(variableInstance.getScopeType());
        this.copyVariableValue(historicVariableInstance, variableInstance, createTime);
        historicVariableInstance.setCreateTime(createTime);
        historicVariableInstance.setLastUpdatedTime(createTime);
        return historicVariableInstance;
    }

    @Override
    public HistoricVariableInstanceEntity createAndInsert(VariableInstanceEntity variableInstance, Date createTime) {
        HistoricVariableInstanceEntity historicVariableInstance = this.create(variableInstance, createTime);
        this.insert(historicVariableInstance);
        return historicVariableInstance;
    }

    @Override
    public void copyVariableValue(HistoricVariableInstanceEntity historicVariableInstance, VariableInstanceEntity variableInstance, Date updateTime) {
        historicVariableInstance.setTextValue(variableInstance.getTextValue());
        historicVariableInstance.setTextValue2(variableInstance.getTextValue2());
        historicVariableInstance.setDoubleValue(variableInstance.getDoubleValue());
        historicVariableInstance.setLongValue(variableInstance.getLongValue());
        historicVariableInstance.setVariableType(variableInstance.getType());
        if (variableInstance.getByteArrayRef() != null) {
            historicVariableInstance.setBytes(variableInstance.getBytes());
        }
        historicVariableInstance.setLastUpdatedTime(updateTime);
    }

    public void delete(HistoricVariableInstanceEntity entity, boolean fireDeleteEvent) {
        super.delete((Entity)entity, fireDeleteEvent);
        if (entity.getByteArrayRef() != null) {
            entity.getByteArrayRef().delete(((VariableServiceConfiguration)this.serviceConfiguration).getEngineName());
        }
    }

    @Override
    public void deleteHistoricVariableInstanceByProcessInstanceId(String historicProcessInstanceId) {
        if (((VariableServiceConfiguration)this.serviceConfiguration).isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            List<HistoricVariableInstanceEntity> historicProcessVariables = ((HistoricVariableInstanceDataManager)this.dataManager).findHistoricVariableInstancesByProcessInstanceId(historicProcessInstanceId);
            for (HistoricVariableInstanceEntity historicProcessVariable : historicProcessVariables) {
                this.delete(historicProcessVariable);
            }
        }
    }

    @Override
    public long findHistoricVariableInstanceCountByQueryCriteria(HistoricVariableInstanceQueryImpl historicProcessVariableQuery) {
        return ((HistoricVariableInstanceDataManager)this.dataManager).findHistoricVariableInstanceCountByQueryCriteria(historicProcessVariableQuery);
    }

    @Override
    public List<HistoricVariableInstance> findHistoricVariableInstancesByQueryCriteria(HistoricVariableInstanceQueryImpl historicProcessVariableQuery) {
        return ((HistoricVariableInstanceDataManager)this.dataManager).findHistoricVariableInstancesByQueryCriteria(historicProcessVariableQuery);
    }

    @Override
    public HistoricVariableInstanceEntity findHistoricVariableInstanceByVariableInstanceId(String variableInstanceId) {
        return ((HistoricVariableInstanceDataManager)this.dataManager).findHistoricVariableInstanceByVariableInstanceId(variableInstanceId);
    }

    @Override
    public List<HistoricVariableInstanceEntity> findHistoricalVariableInstancesByProcessInstanceId(String processInstanceId) {
        return ((HistoricVariableInstanceDataManager)this.dataManager).findHistoricVariableInstancesByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<HistoricVariableInstanceEntity> findHistoricalVariableInstancesByTaskId(String taskId) {
        return ((HistoricVariableInstanceDataManager)this.dataManager).findHistoricVariableInstancesByTaskId(taskId);
    }

    @Override
    public List<HistoricVariableInstanceEntity> findHistoricalVariableInstancesByScopeIdAndScopeType(String scopeId, String scopeType) {
        return ((HistoricVariableInstanceDataManager)this.dataManager).findHistoricalVariableInstancesByScopeIdAndScopeType(scopeId, scopeType);
    }

    @Override
    public List<HistoricVariableInstanceEntity> findHistoricalVariableInstancesBySubScopeIdAndScopeType(String subScopeId, String scopeType) {
        return ((HistoricVariableInstanceDataManager)this.dataManager).findHistoricalVariableInstancesBySubScopeIdAndScopeType(subScopeId, scopeType);
    }

    @Override
    public void deleteHistoricVariableInstancesByTaskId(String taskId) {
        if (((VariableServiceConfiguration)this.serviceConfiguration).isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            List<HistoricVariableInstanceEntity> historicProcessVariables = ((HistoricVariableInstanceDataManager)this.dataManager).findHistoricVariableInstancesByTaskId(taskId);
            for (HistoricVariableInstanceEntity historicProcessVariable : historicProcessVariables) {
                this.delete(historicProcessVariable);
            }
        }
    }

    @Override
    public void deleteHistoricVariableInstancesForNonExistingProcessInstances() {
        if (((VariableServiceConfiguration)this.serviceConfiguration).isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            ((HistoricVariableInstanceDataManager)this.dataManager).deleteHistoricVariableInstancesForNonExistingProcessInstances();
        }
    }

    @Override
    public void deleteHistoricVariableInstancesForNonExistingCaseInstances() {
        if (((VariableServiceConfiguration)this.serviceConfiguration).isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            ((HistoricVariableInstanceDataManager)this.dataManager).deleteHistoricVariableInstancesForNonExistingCaseInstances();
        }
    }

    @Override
    public List<HistoricVariableInstance> findHistoricVariableInstancesByNativeQuery(Map<String, Object> parameterMap) {
        return ((HistoricVariableInstanceDataManager)this.dataManager).findHistoricVariableInstancesByNativeQuery(parameterMap);
    }

    @Override
    public long findHistoricVariableInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return ((HistoricVariableInstanceDataManager)this.dataManager).findHistoricVariableInstanceCountByNativeQuery(parameterMap);
    }
}

