/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.context.Context;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.service.impl.types.CacheableVariable;
import org.flowable.variable.service.impl.types.EntityManagerSession;
import org.flowable.variable.service.impl.types.JPAEntityMappings;

public class JPAEntityVariableType
implements VariableType,
CacheableVariable {
    public static final String TYPE_NAME = "jpa-entity";
    private JPAEntityMappings mappings = new JPAEntityMappings();
    private boolean forceCacheable;

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return this.forceCacheable;
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return this.mappings.isJPAEntity(value);
    }

    public void setValue(Object value, ValueFields valueFields) {
        EntityManagerSession entityManagerSession = (EntityManagerSession)Context.getCommandContext().getSession(EntityManagerSession.class);
        if (entityManagerSession == null) {
            throw new FlowableException("Cannot set JPA variable: " + EntityManagerSession.class + " not configured");
        }
        entityManagerSession.flush();
        if (value != null) {
            String className = this.mappings.getJPAClassString(value);
            String idString = this.mappings.getJPAIdString(value);
            valueFields.setTextValue(className);
            valueFields.setTextValue2(idString);
        } else {
            valueFields.setTextValue(null);
            valueFields.setTextValue2(null);
        }
    }

    public Object getValue(ValueFields valueFields) {
        if (valueFields.getTextValue() != null && valueFields.getTextValue2() != null) {
            return this.mappings.getJPAEntity(valueFields.getTextValue(), valueFields.getTextValue2());
        }
        return null;
    }

    @Override
    public void setForceCacheable(boolean forceCachedValue) {
        this.forceCacheable = forceCachedValue;
    }
}

