/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl;

import java.util.List;
import org.flowable.engine.common.impl.context.Context;
import org.flowable.engine.common.impl.persistence.cache.EntityCache;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.flowable.variable.service.HistoricVariableService;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.HistoricVariableInstanceQueryImpl;
import org.flowable.variable.service.impl.ServiceImpl;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntityManager;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class HistoricVariableServiceImpl
extends ServiceImpl
implements HistoricVariableService {
    public HistoricVariableServiceImpl() {
    }

    public HistoricVariableServiceImpl(VariableServiceConfiguration variableServiceConfiguration) {
        super(variableServiceConfiguration);
    }

    @Override
    public HistoricVariableInstanceEntity getHistoricVariableInstance(String id) {
        return (HistoricVariableInstanceEntity)this.getHistoricVariableInstanceEntityManager().findById(id);
    }

    @Override
    public List<HistoricVariableInstance> findHistoricVariableInstancesByQueryCriteria(HistoricVariableInstanceQueryImpl query) {
        return this.getHistoricVariableInstanceEntityManager().findHistoricVariableInstancesByQueryCriteria(query);
    }

    @Override
    public HistoricVariableInstanceEntity createHistoricVariableInstance() {
        return (HistoricVariableInstanceEntity)this.getHistoricVariableInstanceEntityManager().create();
    }

    @Override
    public void insertHistoricVariableInstance(HistoricVariableInstanceEntity variable) {
        this.getHistoricVariableInstanceEntityManager().insert(variable);
    }

    @Override
    public HistoricVariableInstanceEntity createAndInsert(VariableInstanceEntity variable) {
        return this.getHistoricVariableInstanceEntityManager().createAndInsert(variable);
    }

    @Override
    public void recordVariableUpdate(VariableInstanceEntity variableInstanceEntity) {
        HistoricVariableInstanceEntity historicProcessVariable = (HistoricVariableInstanceEntity)this.getEntityCache().findInCache(HistoricVariableInstanceEntity.class, variableInstanceEntity.getId());
        HistoricVariableInstanceEntityManager historicVariableInstanceEntityManager = this.getHistoricVariableInstanceEntityManager();
        if (historicProcessVariable == null) {
            historicProcessVariable = (HistoricVariableInstanceEntity)historicVariableInstanceEntityManager.findById(variableInstanceEntity.getId());
        }
        if (historicProcessVariable != null) {
            historicVariableInstanceEntityManager.copyVariableValue(historicProcessVariable, variableInstanceEntity);
        } else {
            historicVariableInstanceEntityManager.createAndInsert(variableInstanceEntity);
        }
    }

    @Override
    public void recordVariableRemoved(VariableInstanceEntity variableInstanceEntity) {
        HistoricVariableInstanceEntity historicProcessVariable = (HistoricVariableInstanceEntity)this.getEntityCache().findInCache(HistoricVariableInstanceEntity.class, variableInstanceEntity.getId());
        HistoricVariableInstanceEntityManager historicVariableInstanceEntityManager = this.getHistoricVariableInstanceEntityManager();
        if (historicProcessVariable == null) {
            historicProcessVariable = (HistoricVariableInstanceEntity)historicVariableInstanceEntityManager.findById(variableInstanceEntity.getId());
        }
        if (historicProcessVariable != null) {
            this.getHistoricVariableInstanceEntityManager().delete(historicProcessVariable);
        }
    }

    protected EntityCache getEntityCache() {
        return (EntityCache)Context.getCommandContext().getSession(EntityCache.class);
    }

    @Override
    public void deleteHistoricVariableInstance(HistoricVariableInstanceEntity historicVariable) {
        this.getHistoricVariableInstanceEntityManager().delete(historicVariable);
    }

    @Override
    public void deleteHistoricVariableInstancesByProcessInstanceId(String processInstanceId) {
        this.getHistoricVariableInstanceEntityManager().deleteHistoricVariableInstanceByProcessInstanceId(processInstanceId);
    }

    @Override
    public void deleteHistoricVariableInstancesByTaskId(String taskId) {
        this.getHistoricVariableInstanceEntityManager().deleteHistoricVariableInstancesByTaskId(taskId);
    }
}

