/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime.variable;

import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.ui.task.model.runtime.RestVariable;
import org.flowable.ui.task.rest.runtime.variable.RestVariableConverter;
import org.springframework.stereotype.Component;

@Component
public class LongRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "long";
    }

    @Override
    public Class<?> getVariableType() {
        return Long.class;
    }

    @Override
    public Object getVariableValue(RestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof Number)) {
                throw new FlowableIllegalArgumentException("Converter can only convert longs");
            }
            return ((Number)result.getValue()).longValue();
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, RestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof Long)) {
                throw new FlowableIllegalArgumentException("Converter can only convert integers");
            }
            result.setValue(variableValue);
        } else {
            result.setValue(null);
        }
    }
}

