/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletResponse;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.task.model.runtime.ContentItemRepresentation;
import org.flowable.ui.task.rest.runtime.AbstractRelatedContentResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/app"})
public class RelatedContentResource
extends AbstractRelatedContentResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelatedContentResource.class);
    protected ObjectMapper objectMapper = new ObjectMapper();

    @Override
    @GetMapping(value={"/rest/tasks/{taskId}/content"})
    public ResultListDataRepresentation getContentItemsForTask(@PathVariable(value="taskId") String taskId) {
        return super.getContentItemsForTask(taskId);
    }

    @Override
    @GetMapping(value={"/rest/process-instances/{processInstanceId}/content"})
    public ResultListDataRepresentation getContentItemsForProcessInstance(@PathVariable(value="processInstanceId") String processInstanceId) {
        return super.getContentItemsForProcessInstance(processInstanceId);
    }

    @Override
    @GetMapping(value={"/rest/case-instances/{caseInstanceId}/content"})
    public ResultListDataRepresentation getContentItemsForCase(@PathVariable(value="caseInstanceId") String caseInstanceId) {
        return super.getContentItemsForCase(caseInstanceId);
    }

    @Override
    @PostMapping(value={"/rest/tasks/{taskId}/raw-content"})
    public ContentItemRepresentation createContentItemOnTask(@PathVariable(value="taskId") String taskId, @RequestParam(value="file") MultipartFile file) {
        return super.createContentItemOnTask(taskId, file);
    }

    @PostMapping(value={"/rest/tasks/{taskId}/raw-content/text"})
    public String createContentItemOnTaskText(@PathVariable(value="taskId") String taskId, @RequestParam(value="file") MultipartFile file) {
        ContentItemRepresentation contentItem = super.createContentItemOnTask(taskId, file);
        String contentItemJson = null;
        try {
            contentItemJson = this.objectMapper.writeValueAsString((Object)contentItem);
        }
        catch (Exception e) {
            LOGGER.error("Error while processing ContentItem representation json", (Throwable)e);
            throw new InternalServerErrorException("ContentItem on task could not be saved");
        }
        return contentItemJson;
    }

    @Override
    @PostMapping(value={"/rest/tasks/{taskId}/content"})
    public ContentItemRepresentation createContentItemOnTask(@PathVariable(value="taskId") String taskId, @RequestBody ContentItemRepresentation contentItem) {
        return super.createContentItemOnTask(taskId, contentItem);
    }

    @Override
    @PostMapping(value={"/rest/processes/{processInstanceId}/content"})
    public ContentItemRepresentation createContentItemOnProcessInstance(@PathVariable(value="processInstanceId") String processInstanceId, @RequestBody ContentItemRepresentation contentItem) {
        return super.createContentItemOnProcessInstance(processInstanceId, contentItem);
    }

    @Override
    @PostMapping(value={"/rest/process-instances/{processInstanceId}/raw-content"})
    public ContentItemRepresentation createContentItemOnProcessInstance(@PathVariable(value="processInstanceId") String processInstanceId, @RequestParam(value="file") MultipartFile file) {
        return super.createContentItemOnProcessInstance(processInstanceId, file);
    }

    @PostMapping(value={"/rest/process-instances/{processInstanceId}/raw-content/text"})
    public String createContentItemOnProcessInstanceText(@PathVariable(value="processInstanceId") String processInstanceId, @RequestParam(value="file") MultipartFile file) {
        ContentItemRepresentation contentItem = super.createContentItemOnProcessInstance(processInstanceId, file);
        String contentItemJson = null;
        try {
            contentItemJson = this.objectMapper.writeValueAsString((Object)contentItem);
        }
        catch (Exception e) {
            LOGGER.error("Error while processing ContentItem representation json", (Throwable)e);
            throw new InternalServerErrorException("ContentItem on process instance could not be saved");
        }
        return contentItemJson;
    }

    @Override
    @PostMapping(value={"/rest/case-instances/{caseId}/raw-content"})
    public ContentItemRepresentation createContentItemOnCase(@PathVariable(value="caseId") String caseId, @RequestParam(value="file") MultipartFile file) {
        return super.createContentItemOnCase(caseId, file);
    }

    @PostMapping(value={"/rest/case-instances/{caseId}/raw-content/text"})
    public String createContentItemOnCaseText(@PathVariable(value="caseId") String caseId, @RequestParam(value="file") MultipartFile file) {
        ContentItemRepresentation contentItem = super.createContentItemOnCase(caseId, file);
        String contentItemJson = null;
        try {
            contentItemJson = this.objectMapper.writeValueAsString((Object)contentItem);
        }
        catch (Exception e) {
            LOGGER.error("Error while processing ContentItem representation json", (Throwable)e);
            throw new InternalServerErrorException("ContentItem on process instance could not be saved");
        }
        return contentItemJson;
    }

    @Override
    @PostMapping(value={"/rest/content/raw"})
    public ContentItemRepresentation createTemporaryRawContentItem(@RequestParam(value="file") MultipartFile file) {
        return super.createTemporaryRawContentItem(file);
    }

    @PostMapping(value={"/rest/content/raw/text"})
    public String createTemporaryRawContentItemText(@RequestParam(value="file") MultipartFile file) {
        ContentItemRepresentation contentItem = super.createTemporaryRawContentItem(file);
        String contentItemJson = null;
        try {
            contentItemJson = this.objectMapper.writeValueAsString((Object)contentItem);
        }
        catch (Exception e) {
            LOGGER.error("Error while processing ContentItem representation json", (Throwable)e);
            throw new InternalServerErrorException("ContentItem could not be saved");
        }
        return contentItemJson;
    }

    @PostMapping(value={"/rest/content"})
    public ContentItemRepresentation createTemporaryRelatedContent(@RequestBody ContentItemRepresentation contentItem) {
        return this.addContentItem(contentItem, null, null, false);
    }

    @Override
    @DeleteMapping(value={"/rest/content/{contentId}"})
    public void deleteContent(@PathVariable(value="contentId") String contentId, HttpServletResponse response) {
        super.deleteContent(contentId, response);
    }

    @Override
    @GetMapping(value={"/rest/content/{contentId}"})
    public ContentItemRepresentation getContent(@PathVariable(value="contentId") String contentId) {
        return super.getContent(contentId);
    }

    @Override
    @GetMapping(value={"/rest/content/{contentId}/raw"})
    public void getRawContent(@PathVariable(value="contentId") String contentId, HttpServletResponse response) {
        super.getRawContent(contentId, response);
    }
}

