/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.servlet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@ComponentScan(value={"org.flowable.ui.task.rest", "org.flowable.ui.common.rest"})
@EnableAsync
public class AppDispatcherServletConfiguration
implements WebMvcRegistrations {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppDispatcherServletConfiguration.class);

    public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        LOGGER.debug("Creating requestMappingHandlerMapping");
        RequestMappingHandlerMapping requestMappingHandlerMapping = new RequestMappingHandlerMapping();
        requestMappingHandlerMapping.setRemoveSemicolonContent(false);
        return requestMappingHandlerMapping;
    }

    @Bean
    public WebMvcConfigurer workflow() {
        return new WebMvcConfigurer(){

            public void addViewControllers(@NonNull ViewControllerRegistry registry) {
                registry.addViewController("/workflow").setViewName("redirect:/workflow/");
                registry.addViewController("/workflow/").setViewName("forward:/workflow/index.html");
            }
        };
    }
}

