/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SendEventServiceTask;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.cmmn.converter.CmmnXmlConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.GenericEventListener;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Stage;
import org.flowable.dmn.editor.converter.DmnJsonConverter;
import org.flowable.dmn.editor.converter.DmnJsonConverterContext;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.xml.converter.DmnXMLConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.eventregistry.json.converter.ChannelJsonConverter;
import org.flowable.eventregistry.json.converter.EventJsonConverter;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.AppDefinition;
import org.flowable.ui.modeler.domain.AppModelDefinition;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.repository.ModelRepository;
import org.flowable.ui.modeler.service.ConverterContext;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.flowable.ui.modeler.util.BpmnEventModelUtil;
import org.flowable.ui.modeler.util.CmmnEventModelUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseAppDefinitionService {
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ObjectMapper objectMapper;
    protected BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();
    protected BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
    protected DmnJsonConverter dmnJsonConverter = new DmnJsonConverter();
    protected DmnXMLConverter dmnXMLConverter = new DmnXMLConverter();
    protected CmmnJsonConverter cmmnJsonConverter = new CmmnJsonConverter();
    protected CmmnXmlConverter cmmnXMLConverter = new CmmnXmlConverter();
    protected EventJsonConverter eventJsonConverter = new EventJsonConverter();
    protected ChannelJsonConverter channelJsonConverter = new ChannelJsonConverter();

    protected void postProcessFlowElements(List<FlowElement> eventRegistryElements, Map<String, StartEvent> noneStartEventMap, BpmnModel bpmnModel) {
        for (Process process : bpmnModel.getProcesses()) {
            this.postProcessFlowElements(process.getFlowElements(), eventRegistryElements, noneStartEventMap, process.getId(), bpmnModel);
        }
    }

    protected void postProcessFlowElements(Collection<FlowElement> traverseElementList, List<FlowElement> eventRegistryElements, Map<String, StartEvent> noneStartEventMap, String processId, BpmnModel bpmnModel) {
        for (FlowElement flowElement : traverseElementList) {
            if (flowElement instanceof Event) {
                StartEvent startEvent;
                List eventTypeElements = (List)flowElement.getExtensionElements().get("eventType");
                if (eventTypeElements != null && eventTypeElements.size() > 0) {
                    eventRegistryElements.add(flowElement);
                }
                if (!(flowElement instanceof StartEvent) || !CollectionUtils.isEmpty((Collection)(startEvent = (StartEvent)flowElement).getEventDefinitions())) continue;
                if (StringUtils.isEmpty((CharSequence)startEvent.getInitiator())) {
                    startEvent.setInitiator("initiator");
                }
                noneStartEventMap.put(processId, startEvent);
                continue;
            }
            if (flowElement instanceof SendEventServiceTask) {
                SendEventServiceTask task = (SendEventServiceTask)flowElement;
                if (!StringUtils.isNotEmpty((CharSequence)task.getEventType())) continue;
                eventRegistryElements.add(flowElement);
                continue;
            }
            if (!(flowElement instanceof SubProcess)) continue;
            SubProcess subProcess = (SubProcess)flowElement;
            this.postProcessFlowElements(subProcess.getFlowElements(), eventRegistryElements, noneStartEventMap, processId, bpmnModel);
        }
    }

    protected void postProcessPlanItemDefinitions(List<BaseElement> eventRegistryElements, CmmnModel cmmnModel) {
        for (Case caseModel : cmmnModel.getCases()) {
            if (StringUtils.isNotEmpty((CharSequence)caseModel.getStartEventType())) {
                eventRegistryElements.add((BaseElement)caseModel);
            }
            this.postProcessPlanItemDefinitions(caseModel.getPlanModel().getPlanItemDefinitions(), eventRegistryElements);
        }
    }

    protected void postProcessPlanItemDefinitions(Collection<PlanItemDefinition> traverseElementList, List<BaseElement> eventRegistryElements) {
        for (PlanItemDefinition planItemDefinition : traverseElementList) {
            if (planItemDefinition instanceof GenericEventListener) {
                GenericEventListener genericEventListener = (GenericEventListener)planItemDefinition;
                if (!StringUtils.isNotEmpty((CharSequence)genericEventListener.getEventType())) continue;
                eventRegistryElements.add((BaseElement)genericEventListener);
                continue;
            }
            if (planItemDefinition instanceof org.flowable.cmmn.model.SendEventServiceTask) {
                org.flowable.cmmn.model.SendEventServiceTask task = (org.flowable.cmmn.model.SendEventServiceTask)planItemDefinition;
                if (!StringUtils.isNotEmpty((CharSequence)task.getEventType())) continue;
                eventRegistryElements.add((BaseElement)task);
                continue;
            }
            if (!(planItemDefinition instanceof Stage)) continue;
            Stage stage = (Stage)planItemDefinition;
            this.postProcessPlanItemDefinitions(stage.getPlanItemDefinitions(), eventRegistryElements);
        }
    }

    protected void processUserTasks(Collection<FlowElement> flowElements, Process process, Map<String, StartEvent> startEventMap) {
        for (FlowElement flowElement : flowElements) {
            if (flowElement instanceof UserTask) {
                UserTask userTask = (UserTask)flowElement;
                if (!"$INITIATOR".equals(userTask.getAssignee()) || startEventMap.get(process.getId()) == null) continue;
                userTask.setAssignee("${" + startEventMap.get(process.getId()).getInitiator() + "}");
                continue;
            }
            if (!(flowElement instanceof SubProcess)) continue;
            this.processUserTasks(((SubProcess)flowElement).getFlowElements(), process, startEventMap);
        }
    }

    protected String getAppDefinitionJson(Model appDefinitionModel, AppDefinition appDefinition) {
        ObjectNode appDefinitionNode = this.objectMapper.createObjectNode();
        appDefinitionNode.put("key", appDefinitionModel.getKey());
        appDefinitionNode.put("name", appDefinitionModel.getName());
        appDefinitionNode.put("description", appDefinitionModel.getDescription());
        appDefinitionNode.put("theme", appDefinition.getTheme());
        appDefinitionNode.put("icon", appDefinition.getIcon());
        appDefinitionNode.put("usersAccess", appDefinition.getUsersAccess());
        appDefinitionNode.put("groupsAccess", appDefinition.getGroupsAccess());
        return appDefinitionNode.toString();
    }

    protected AppDefinition resolveAppDefinition(Model appDefinitionModel) throws Exception {
        AppDefinition appDefinition = (AppDefinition)this.objectMapper.readValue(appDefinitionModel.getModelEditorJson(), AppDefinition.class);
        return appDefinition;
    }

    protected byte[] createDeployableZipArtifact(Model appDefinitionModel, AppDefinition appDefinition) {
        byte[] deployZipArtifact = null;
        HashMap<String, byte[]> deployableAssets = new HashMap<String, byte[]>();
        if (CollectionUtils.isNotEmpty(appDefinition.getModels()) || CollectionUtils.isNotEmpty(appDefinition.getCmmnModels())) {
            Collection<Model> allDecisionTableModels;
            String appDefinitionJson = this.getAppDefinitionJson(appDefinitionModel, appDefinition);
            byte[] appDefinitionJsonBytes = appDefinitionJson.getBytes(StandardCharsets.UTF_8);
            deployableAssets.put(appDefinitionModel.getKey() + ".app", appDefinitionJsonBytes);
            ConverterContext converterContext = new ConverterContext(this.modelService, this.objectMapper);
            this.createDeployableAppModels(appDefinitionModel, appDefinition, deployableAssets, converterContext);
            Collection<Model> allFormModels = converterContext.getAllFormModels();
            if (allFormModels.size() > 0) {
                for (Model model : allFormModels) {
                    String formModelEditorJson = model.getModelEditorJson();
                    byte[] formModelEditorJsonBytes = formModelEditorJson.getBytes(StandardCharsets.UTF_8);
                    deployableAssets.put("form-" + model.getKey() + ".form", formModelEditorJsonBytes);
                }
            }
            if ((allDecisionTableModels = converterContext.getAllDecisionTableModels()).size() > 0) {
                for (Model decisionTableModel2 : allDecisionTableModels) {
                    try {
                        JsonNode decisionTableNode = this.objectMapper.readTree(decisionTableModel2.getModelEditorJson());
                        DmnDefinition dmnDefinition = this.dmnJsonConverter.convertToDmn(decisionTableNode, decisionTableModel2.getId());
                        byte[] dmnXMLBytes = this.dmnXMLConverter.convertToXML(dmnDefinition);
                        deployableAssets.put("dmn-" + decisionTableModel2.getKey() + ".dmn", dmnXMLBytes);
                    }
                    catch (Exception e) {
                        throw new InternalServerErrorException(String.format("Error converting decision table %s to XML", decisionTableModel2.getName()));
                    }
                }
            }
            converterContext.getAllReferencedDecisionTableModels().forEach(decisionTableModel -> converterContext.getDecisionTableKeyToJsonStringMap().put(decisionTableModel.getKey(), decisionTableModel.getModelEditorJson()));
            Collection<Model> collection = converterContext.getAllDecisionServiceModels();
            if (collection.size() > 0) {
                for (Model decisionServiceModel : collection) {
                    try {
                        JsonNode decisionServiceNode = this.objectMapper.readTree(decisionServiceModel.getModelEditorJson());
                        DmnDefinition dmnDefinition = this.dmnJsonConverter.convertToDmn(decisionServiceNode, decisionServiceModel.getId(), (DmnJsonConverterContext)converterContext);
                        byte[] dmnXMLBytes = this.dmnXMLConverter.convertToXML(dmnDefinition);
                        deployableAssets.put("dmn-" + decisionServiceModel.getKey() + ".dmn", dmnXMLBytes);
                    }
                    catch (Exception e) {
                        throw new InternalServerErrorException(String.format("Error converting decision service %s to XML", decisionServiceModel.getName()));
                    }
                }
            }
            deployZipArtifact = this.createDeployZipArtifact(deployableAssets);
        }
        return deployZipArtifact;
    }

    protected void createDeployableAppModels(Model appDefinitionModel, AppDefinition appDefinition, Map<String, byte[]> deployableAssets, ConverterContext converterContext) {
        ArrayList<AppModelDefinition> appModels = new ArrayList<AppModelDefinition>();
        if (appDefinition.getModels() != null) {
            appModels.addAll(appDefinition.getModels());
        }
        if (appDefinition.getCmmnModels() != null) {
            appModels.addAll(appDefinition.getCmmnModels());
        }
        for (AppModelDefinition appModelDef : appModels) {
            String caseModelKey = converterContext.getCaseModelKeyForCaseModelId(appModelDef.getId());
            String processModelKey = converterContext.getProcessModelKeyForProcessModelId(appModelDef.getId());
            if (caseModelKey != null || processModelKey != null) {
                return;
            }
            Model model = this.modelService.getModel(appModelDef.getId());
            if (model == null) {
                throw new BadRequestException(String.format("Model %s for app definition %s could not be found", appModelDef.getId(), appDefinitionModel.getId()));
            }
            this.createDeployableModels(model, deployableAssets, converterContext);
        }
    }

    protected void createDeployableModels(AbstractModel parentModel, Map<String, byte[]> deployableAssets, ConverterContext converterContext) {
        ArrayList<BaseElement> eventRegistryElements;
        List<Model> referencedModels = this.modelRepository.findByParentModelId(parentModel.getId());
        for (Model childModel : referencedModels) {
            if (2 == childModel.getModelType()) {
                converterContext.addFormModel(childModel);
                continue;
            }
            if (4 == childModel.getModelType()) {
                converterContext.addDecisionTableModel(childModel);
                continue;
            }
            if (6 == childModel.getModelType()) {
                converterContext.addDecisionServiceModel(childModel);
                List<Model> referencedDecisionTableModels = this.modelRepository.findByParentModelId(childModel.getId());
                referencedDecisionTableModels.stream().filter(refModel -> 4 == refModel.getModelType()).forEach(converterContext::addReferencedDecisionTableModel);
                continue;
            }
            if (5 == childModel.getModelType()) {
                converterContext.addCaseModel(childModel);
                this.createDeployableModels(childModel, deployableAssets, converterContext);
                continue;
            }
            if (0 != childModel.getModelType()) continue;
            converterContext.addProcessModel(childModel);
            this.createDeployableModels(childModel, deployableAssets, converterContext);
        }
        HashMap<String, EventModel> eventModelMap = new HashMap<String, EventModel>();
        HashMap<String, ChannelModel> channelModelMap = new HashMap<String, ChannelModel>();
        if (parentModel.getModelType() == null || parentModel.getModelType() == 0) {
            BpmnModel bpmnModel = this.modelService.getBpmnModel(parentModel, converterContext);
            eventRegistryElements = new ArrayList<BaseElement>();
            HashMap<String, StartEvent> noneStartEventMap = new HashMap<String, StartEvent>();
            this.postProcessFlowElements(eventRegistryElements, noneStartEventMap, bpmnModel);
            BpmnEventModelUtil.fillEventModelMap(eventRegistryElements, eventModelMap);
            BpmnEventModelUtil.fillChannelModelMap(eventRegistryElements, channelModelMap);
            for (Process process : bpmnModel.getProcesses()) {
                this.processUserTasks(process.getFlowElements(), process, noneStartEventMap);
            }
            byte[] modelXML = this.modelService.getBpmnXML(bpmnModel);
            deployableAssets.put(parentModel.getKey().replaceAll(" ", "") + ".bpmn", modelXML);
        } else {
            CmmnModel cmmnModel = this.modelService.getCmmnModel(parentModel, converterContext);
            eventRegistryElements = new ArrayList();
            this.postProcessPlanItemDefinitions(eventRegistryElements, cmmnModel);
            CmmnEventModelUtil.fillEventModelMap(eventRegistryElements, eventModelMap);
            CmmnEventModelUtil.fillChannelModelMap(eventRegistryElements, channelModelMap);
            byte[] modelXML = this.modelService.getCmmnXML(cmmnModel);
            deployableAssets.put(parentModel.getKey().replaceAll(" ", "") + ".cmmn", modelXML);
        }
        if (eventModelMap.size() > 0) {
            for (EventModel eventModel : eventModelMap.values()) {
                String eventJson = this.eventJsonConverter.convertToJson(eventModel);
                deployableAssets.put("event-" + eventModel.getKey() + ".event", eventJson.getBytes(StandardCharsets.UTF_8));
            }
            if (channelModelMap.size() > 0) {
                for (ChannelModel channelModel : channelModelMap.values()) {
                    String channelJson = this.channelJsonConverter.convertToJson(channelModel);
                    deployableAssets.put("channel-" + channelModel.getKey() + ".channel", channelJson.getBytes(StandardCharsets.UTF_8));
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected byte[] createDeployZipArtifact(Map<String, byte[]> deployableAssets) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

