/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.conf;

import org.flowable.ui.common.properties.FlowableRestAppProperties;
import org.flowable.ui.common.security.ApiHttpSecurityCustomizer;
import org.flowable.ui.modeler.properties.FlowableModelerAppProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;

@Configuration(proxyBeanMethods=false)
@EnableWebSecurity
public class ModelerSecurityConfiguration {

    @Configuration
    @Order(value=3)
    public static class ModelerApiWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        protected final FlowableRestAppProperties restAppProperties;
        protected final FlowableModelerAppProperties modelerAppProperties;
        protected final ApiHttpSecurityCustomizer apiHttpSecurityCustomizer;

        public ModelerApiWebSecurityConfigurationAdapter(FlowableRestAppProperties restAppProperties, FlowableModelerAppProperties modelerAppProperties, ApiHttpSecurityCustomizer apiHttpSecurityCustomizer) {
            this.restAppProperties = restAppProperties;
            this.modelerAppProperties = modelerAppProperties;
            this.apiHttpSecurityCustomizer = apiHttpSecurityCustomizer;
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable();
            if (this.modelerAppProperties.isRestEnabled()) {
                if (this.restAppProperties.isVerifyRestApiPrivilege()) {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/api/editor/**").authorizeRequests().antMatchers(new String[]{"/api/editor/**"})).hasAuthority("access-rest-api");
                } else {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/api/editor/**").authorizeRequests().antMatchers(new String[]{"/api/editor/**"})).authenticated();
                }
                this.apiHttpSecurityCustomizer.customize(http);
            } else {
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/api/editor/**").authorizeRequests().antMatchers(new String[]{"/api/editor/**"})).denyAll();
            }
        }
    }
}

