/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.conf;

import org.flowable.idm.api.IdmIdentityService;
import org.flowable.ui.common.properties.FlowableRestAppProperties;
import org.flowable.ui.common.security.ApiHttpSecurityCustomizer;
import org.flowable.ui.idm.properties.FlowableIdmAppProperties;
import org.flowable.ui.idm.security.UserDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;

@Configuration(proxyBeanMethods=false)
@EnableGlobalMethodSecurity(prePostEnabled=true, jsr250Enabled=true)
public class IdmSecurityConfiguration {
    @Autowired
    protected IdmIdentityService identityService;
    @Autowired
    protected FlowableIdmAppProperties idmAppProperties;

    @Bean
    public UserDetailsService userDetailsService() {
        UserDetailsService userDetailsService = new UserDetailsService();
        userDetailsService.setUserValidityPeriod(this.idmAppProperties.getSecurity().getUserValidityPeriod());
        return userDetailsService;
    }

    @Configuration
    @Order(value=1)
    public static class IdmApiWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        protected final FlowableRestAppProperties restAppProperties;
        protected final FlowableIdmAppProperties idmAppProperties;
        protected final ApiHttpSecurityCustomizer apiHttpSecurityCustomizer;

        public IdmApiWebSecurityConfigurationAdapter(FlowableRestAppProperties restAppProperties, FlowableIdmAppProperties idmAppProperties, ApiHttpSecurityCustomizer apiHttpSecurityCustomizer) {
            this.restAppProperties = restAppProperties;
            this.idmAppProperties = idmAppProperties;
            this.apiHttpSecurityCustomizer = apiHttpSecurityCustomizer;
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable();
            if (this.idmAppProperties.isRestEnabled()) {
                if (this.restAppProperties.isVerifyRestApiPrivilege()) {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/api/idm/**").authorizeRequests().antMatchers(new String[]{"/api/idm/**"})).hasAuthority("access-rest-api");
                } else {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/api/idm/**").authorizeRequests().antMatchers(new String[]{"/api/idm/**"})).authenticated();
                }
                this.apiHttpSecurityCustomizer.customize(http);
            } else {
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/api/idm/**").authorizeRequests().antMatchers(new String[]{"/api/idm/**"})).denyAll();
            }
        }
    }
}

