/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.security;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Base64;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.idm.api.Token;
import org.flowable.ui.common.security.PersistentTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.annotation.Transactional;

public abstract class BasePersistentTokenService
implements PersistentTokenService,
InitializingBean {
    private static final int DEFAULT_SERIES_LENGTH = 16;
    private static final int DEFAULT_TOKEN_LENGTH = 16;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SecureRandom random;
    protected long maxUserSize = 2058L;
    protected Duration maxAge = Duration.ofSeconds(30L);
    private LoadingCache<String, Token> tokenCache;

    public BasePersistentTokenService() {
        this.random = new SecureRandom();
    }

    public void afterPropertiesSet() {
        this.tokenCache = CacheBuilder.newBuilder().maximumSize(this.maxUserSize).expireAfterWrite(this.maxAge).recordStats().build((CacheLoader)new CacheLoader<String, Token>(){

            public Token load(String s) throws Exception {
                return BasePersistentTokenService.this.loadToken(s);
            }
        });
    }

    protected abstract Token loadToken(String var1);

    @Override
    public void delete(Token token) {
        this.tokenCache.invalidate((Object)token.getId());
    }

    @Override
    @Transactional(readOnly=true)
    public Token getToken(String tokenId) {
        try {
            return (Token)this.tokenCache.get((Object)tokenId);
        }
        catch (FlowableObjectNotFoundException e) {
            this.logger.warn("Token id {} does not exist in cache.", (Object)tokenId);
            return null;
        }
        catch (Exception e) {
            this.logger.error("Error loading token id {} from cache", (Object)tokenId, (Object)e);
            return null;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Token invalidateCacheEntryAndGetToken(String tokenId, boolean invalidateCacheEntry) {
        if (invalidateCacheEntry) {
            this.tokenCache.invalidate((Object)tokenId);
        }
        return this.getToken(tokenId);
    }

    protected String generateSeriesData() {
        return this.generateRandomWithoutSlash(16);
    }

    protected String generateTokenData() {
        return this.generateRandomWithoutSlash(16);
    }

    protected String generateRandomWithoutSlash(int size) {
        String data = this.generateRandom(size);
        while (data.contains("/")) {
            data = this.generateRandom(size);
        }
        return data;
    }

    protected String generateRandom(int size) {
        byte[] s = new byte[size];
        this.random.nextBytes(s);
        return new String(Base64.getEncoder().encode(s));
    }

    public long getMaxUserSize() {
        return this.maxUserSize;
    }

    public void setMaxUserSize(long maxUserSize) {
        this.maxUserSize = maxUserSize;
    }

    public Duration getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Duration maxAge) {
        this.maxAge = maxAge;
    }
}

