/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring;

import java.util.concurrent.RejectedExecutionException;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.DefaultAsyncJobExecutor;
import org.flowable.job.service.impl.asyncexecutor.ExecuteAsyncRunnable;
import org.flowable.spring.SpringRejectedJobsHandler;
import org.springframework.core.task.TaskExecutor;

public class SpringAsyncExecutor
extends DefaultAsyncJobExecutor {
    protected TaskExecutor taskExecutor;
    protected SpringRejectedJobsHandler rejectedJobsHandler;

    public SpringAsyncExecutor() {
    }

    public SpringAsyncExecutor(TaskExecutor taskExecutor, SpringRejectedJobsHandler rejectedJobsHandler) {
        this.taskExecutor = taskExecutor;
        this.rejectedJobsHandler = rejectedJobsHandler;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public SpringRejectedJobsHandler getRejectedJobsHandler() {
        return this.rejectedJobsHandler;
    }

    public void setRejectedJobsHandler(SpringRejectedJobsHandler rejectedJobsHandler) {
        this.rejectedJobsHandler = rejectedJobsHandler;
    }

    public boolean executeAsyncJob(JobInfo job) {
        try {
            this.taskExecutor.execute((Runnable)new ExecuteAsyncRunnable(job, this.jobServiceConfiguration, this.jobEntityManager, this.asyncRunnableExecutionExceptionHandler));
            return true;
        }
        catch (RejectedExecutionException e) {
            this.rejectedJobsHandler.jobRejected((AsyncExecutor)this, job);
            return false;
        }
    }

    protected void initAsyncJobExecutionThreadPool() {
    }
}

