/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.eventregistry;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.flowable.app.spring.SpringAppEngineConfiguration;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.EngineConfigurator;
import org.flowable.common.spring.AutoDeploymentStrategy;
import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.flowable.common.spring.SpringEngineConfiguration;
import org.flowable.eventregistry.api.ChannelModelProcessor;
import org.flowable.eventregistry.api.InboundEventPayloadExtractor;
import org.flowable.eventregistry.api.management.EventRegistryChangeDetectionExecutor;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.configurator.EventRegistryEngineConfigurator;
import org.flowable.eventregistry.spring.SpringEventRegistryEngineConfiguration;
import org.flowable.eventregistry.spring.autodeployment.DefaultAutoDeploymentStrategy;
import org.flowable.eventregistry.spring.autodeployment.ResourceParentFolderAutoDeploymentStrategy;
import org.flowable.eventregistry.spring.autodeployment.SingleResourceAutoDeploymentStrategy;
import org.flowable.eventregistry.spring.configurator.SpringEventRegistryConfigurator;
import org.flowable.eventregistry.spring.jms.JmsChannelModelProcessor;
import org.flowable.eventregistry.spring.kafka.KafkaChannelDefinitionProcessor;
import org.flowable.eventregistry.spring.kafka.payload.KafkaConsumerRecordInformationPayloadExtractor;
import org.flowable.eventregistry.spring.management.DefaultSpringEventRegistryChangeDetectionExecutor;
import org.flowable.eventregistry.spring.rabbit.RabbitChannelDefinitionProcessor;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.AbstractSpringEngineAutoConfiguration;
import org.flowable.spring.boot.BaseEngineConfigurationWithConfigurers;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.flowable.spring.boot.FlowableAutoDeploymentProperties;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.ProcessEngineServicesAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineServicesAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnEventRegistry;
import org.flowable.spring.boot.eventregistry.FlowableEventRegistryProperties;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.core.JmsOperations;
import org.springframework.kafka.config.KafkaListenerEndpointRegistry;
import org.springframework.kafka.core.KafkaAdminOperations;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.listener.KafkaConsumerBackoffManager;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration(proxyBeanMethods=false)
@ConditionalOnEventRegistry
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableAutoDeploymentProperties.class, FlowableEventRegistryProperties.class})
@AutoConfigureAfter(value={AppEngineAutoConfiguration.class, ProcessEngineAutoConfiguration.class, KafkaAutoConfiguration.class, JmsAutoConfiguration.class, RabbitAutoConfiguration.class})
@AutoConfigureBefore(value={AppEngineServicesAutoConfiguration.class, ProcessEngineServicesAutoConfiguration.class})
public class EventRegistryAutoConfiguration
extends AbstractSpringEngineAutoConfiguration {
    protected final FlowableEventRegistryProperties eventProperties;
    protected final FlowableAutoDeploymentProperties autoDeploymentProperties;

    public EventRegistryAutoConfiguration(FlowableProperties flowableProperties, FlowableEventRegistryProperties eventProperties, FlowableAutoDeploymentProperties autoDeploymentProperties) {
        super(flowableProperties);
        this.eventProperties = eventProperties;
        this.autoDeploymentProperties = autoDeploymentProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringEventRegistryEngineConfiguration eventEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager, ObjectProvider<ObjectMapper> objectMapperProvider, ObjectProvider<List<ChannelModelProcessor>> channelModelProcessors, ObjectProvider<List<AutoDeploymentStrategy<EventRegistryEngine>>> eventAutoDeploymentStrategies, ObjectProvider<TaskScheduler> taskScheduler, ObjectProvider<EventRegistryChangeDetectionExecutor> eventRegistryChangeDetectionExecutor) throws IOException {
        ArrayList<Object> deploymentStrategies;
        SpringEventRegistryEngineConfiguration configuration = new SpringEventRegistryEngineConfiguration();
        List<Resource> resources = this.discoverDeploymentResources(this.eventProperties.getResourceLocation(), this.eventProperties.getResourceSuffixes(), this.eventProperties.isDeployResources());
        if (resources != null && !resources.isEmpty()) {
            configuration.setDeploymentResources(resources.toArray(new Resource[0]));
            configuration.setDeploymentName(this.eventProperties.getDeploymentName());
        }
        this.configureSpringEngine((SpringEngineConfiguration)configuration, platformTransactionManager);
        this.configureEngine((AbstractEngineConfiguration)configuration, dataSource);
        ObjectMapper objectMapper = (ObjectMapper)objectMapperProvider.getIfAvailable();
        if (objectMapper != null) {
            configuration.setObjectMapper(objectMapper);
        }
        if ((deploymentStrategies = (ArrayList<Object>)eventAutoDeploymentStrategies.getIfAvailable()) == null) {
            deploymentStrategies = new ArrayList<Object>();
        }
        CommonAutoDeploymentProperties deploymentProperties = this.autoDeploymentProperties.deploymentPropertiesForEngine("eventRegistry");
        deploymentStrategies.add(new DefaultAutoDeploymentStrategy(deploymentProperties));
        deploymentStrategies.add(new SingleResourceAutoDeploymentStrategy(deploymentProperties));
        deploymentStrategies.add(new ResourceParentFolderAutoDeploymentStrategy(deploymentProperties));
        configuration.setDeploymentStrategies(deploymentStrategies);
        List channelProcessors = (List)channelModelProcessors.getIfAvailable();
        if (channelProcessors != null && channelProcessors.size() > 0) {
            for (ChannelModelProcessor channelModelProcessor : channelProcessors) {
                configuration.addChannelModelProcessor(channelModelProcessor);
            }
        }
        configuration.setEnableEventRegistryChangeDetection(this.eventProperties.isEnableChangeDetection());
        EventRegistryChangeDetectionExecutor changeDetectionExecutor = (EventRegistryChangeDetectionExecutor)eventRegistryChangeDetectionExecutor.getIfAvailable();
        if (changeDetectionExecutor != null) {
            configuration.setEventRegistryChangeDetectionExecutor(changeDetectionExecutor);
        }
        return configuration;
    }

    @Bean
    @ConditionalOnProperty(prefix="flowable.eventregistry", name={"enable-change-detection"})
    @ConditionalOnMissingBean
    public EventRegistryChangeDetectionExecutor eventRegistryChangeDetectionExecutor(ObjectProvider<TaskScheduler> taskScheduler) {
        return new DefaultSpringEventRegistryChangeDetectionExecutor(this.eventProperties.getChangeDetectionInitialDelay().toMillis(), this.eventProperties.getChangeDetectionDelay().toMillis(), (TaskScheduler)taskScheduler.getIfAvailable());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={KafkaOperations.class})
    public static class EventRegistryKafkaConfiguration {
        @Bean(value={"kafkaChannelDefinitionProcessor"})
        @ConditionalOnMissingBean(name={"kafkaChannelDefinitionProcessor"})
        public KafkaChannelDefinitionProcessor kafkaChannelDefinitionProcessor(KafkaListenerEndpointRegistry endpointRegistry, KafkaOperations<Object, Object> kafkaOperations, ObjectMapper objectMapper, ObjectProvider<KafkaConsumerBackoffManager> kafkaConsumerBackoffManager, ObjectProvider<KafkaAdminOperations> kafkaAdminOperations) {
            KafkaChannelDefinitionProcessor kafkaChannelDefinitionProcessor = new KafkaChannelDefinitionProcessor(objectMapper);
            kafkaChannelDefinitionProcessor.setEndpointRegistry(endpointRegistry);
            kafkaChannelDefinitionProcessor.setKafkaOperations(kafkaOperations);
            kafkaChannelDefinitionProcessor.setKafkaConsumerBackoffManager((KafkaConsumerBackoffManager)kafkaConsumerBackoffManager.getIfAvailable());
            kafkaChannelDefinitionProcessor.setKafkaAdminOperations((KafkaAdminOperations)kafkaAdminOperations.getIfAvailable());
            return kafkaChannelDefinitionProcessor;
        }

        @Bean(value={"kafkaEventRegistryEngineConfigurer"})
        @ConditionalOnMissingBean(name={"kafkaEventRegistryEngineConfigurer"})
        public EngineConfigurationConfigurer<SpringEventRegistryEngineConfiguration> kafkaEventRegistryEngineConfigurer() {
            return engineConfiguration -> engineConfiguration.registerInboundEventPayloadExtractor("kafka", (InboundEventPayloadExtractor)new KafkaConsumerRecordInformationPayloadExtractor());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={RabbitOperations.class})
    public static class EventRegistryRabbitConfiguration {
        @Bean(value={"rabbitChannelDefinitionProcessor"})
        @ConditionalOnMissingBean(name={"rabbitChannelDefinitionProcessor"})
        public RabbitChannelDefinitionProcessor rabbitChannelDefinitionProcessor(RabbitListenerEndpointRegistry endpointRegistry, RabbitOperations rabbitOperations, ObjectMapper objectMapper) {
            RabbitChannelDefinitionProcessor rabbitChannelDefinitionProcessor = new RabbitChannelDefinitionProcessor(objectMapper);
            rabbitChannelDefinitionProcessor.setEndpointRegistry(endpointRegistry);
            rabbitChannelDefinitionProcessor.setRabbitOperations(rabbitOperations);
            return rabbitChannelDefinitionProcessor;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={JmsOperations.class})
    public static class EventRegistryJmsConfiguration {
        @Bean(value={"jmsChannelDefinitionProcessor"})
        @ConditionalOnMissingBean(name={"jmsChannelDefinitionProcessor"})
        public JmsChannelModelProcessor jmsChannelDefinitionProcessor(JmsListenerEndpointRegistry endpointRegistry, JmsOperations jmsOperations, ObjectMapper objectMapper) {
            JmsChannelModelProcessor jmsChannelDefinitionProcessor = new JmsChannelModelProcessor(objectMapper);
            jmsChannelDefinitionProcessor.setEndpointRegistry(endpointRegistry);
            jmsChannelDefinitionProcessor.setJmsOperations(jmsOperations);
            return jmsChannelDefinitionProcessor;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(type={"org.flowable.app.spring.SpringAppEngineConfiguration"})
    public static class EventRegistryAppEngineConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringEventRegistryEngineConfiguration> {
        @Bean
        @ConditionalOnMissingBean(name={"eventAppEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringAppEngineConfiguration> eventAppEngineConfigurationConfigurer(EventRegistryEngineConfigurator eventRegistryEngineConfigurator) {
            return appEngineConfiguration -> appEngineConfiguration.setEventRegistryConfigurator((EngineConfigurator)eventRegistryEngineConfigurator);
        }

        @Bean
        @ConditionalOnMissingBean
        public EventRegistryEngineConfigurator eventEngineConfigurator(SpringEventRegistryEngineConfiguration configuration) {
            SpringEventRegistryConfigurator eventEngineConfigurator = new SpringEventRegistryConfigurator();
            eventEngineConfigurator.setEventEngineConfiguration((EventRegistryEngineConfiguration)configuration);
            this.invokeConfigurers(configuration);
            return eventEngineConfigurator;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(type={"org.flowable.spring.SpringProcessEngineConfiguration"})
    @ConditionalOnMissingBean(type={"org.flowable.app.spring.SpringAppEngineConfiguration"})
    public static class EventRegistryProcessConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringEventRegistryEngineConfiguration> {
        @Bean
        @ConditionalOnMissingBean(name={"eventProcessEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringProcessEngineConfiguration> eventProcessEngineConfigurationConfigurer(EventRegistryEngineConfigurator eventRegistryEngineConfigurator) {
            return processEngineConfiguration -> processEngineConfiguration.setEventRegistryConfigurator((EngineConfigurator)eventRegistryEngineConfigurator);
        }

        @Bean
        @ConditionalOnMissingBean
        public EventRegistryEngineConfigurator eventEngineConfigurator(SpringEventRegistryEngineConfiguration configuration) {
            SpringEventRegistryConfigurator eventEngineConfigurator = new SpringEventRegistryConfigurator();
            eventEngineConfigurator.setEventEngineConfiguration((EventRegistryEngineConfiguration)configuration);
            this.invokeConfigurers(configuration);
            return eventEngineConfigurator;
        }
    }
}

