/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.cmmn;

import org.flowable.app.engine.AppEngine;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.CmmnTaskService;
import org.flowable.cmmn.api.DynamicCmmnService;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.CmmnEngines;
import org.flowable.cmmn.spring.CmmnEngineFactoryBean;
import org.flowable.cmmn.spring.SpringCmmnEngineConfiguration;
import org.flowable.engine.ProcessEngine;
import org.flowable.spring.boot.BaseEngineConfigurationWithConfigurers;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.ProcessEngineServicesAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineServicesAutoConfiguration;
import org.flowable.spring.boot.cmmn.CmmnEngineAutoConfiguration;
import org.flowable.spring.boot.cmmn.FlowableCmmnProperties;
import org.flowable.spring.boot.condition.ConditionalOnCmmnEngine;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCmmnEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableCmmnProperties.class})
@AutoConfigureAfter(value={CmmnEngineAutoConfiguration.class, AppEngineServicesAutoConfiguration.class, ProcessEngineServicesAutoConfiguration.class})
public class CmmnEngineServicesAutoConfiguration {
    @Bean
    public CmmnRuntimeService cmmnRuntimeService(CmmnEngine cmmnEngine) {
        return cmmnEngine.getCmmnRuntimeService();
    }

    @Bean
    public DynamicCmmnService dynamicCmmnService(CmmnEngine cmmnEngine) {
        return cmmnEngine.getDynamicCmmnService();
    }

    @Bean
    public CmmnTaskService cmmnTaskService(CmmnEngine cmmnEngine) {
        return cmmnEngine.getCmmnTaskService();
    }

    @Bean
    public CmmnManagementService cmmnManagementService(CmmnEngine cmmnEngine) {
        return cmmnEngine.getCmmnManagementService();
    }

    @Bean
    public CmmnRepositoryService cmmnRepositoryService(CmmnEngine cmmnEngine) {
        return cmmnEngine.getCmmnRepositoryService();
    }

    @Bean
    public CmmnHistoryService cmmnHistoryService(CmmnEngine cmmnEngine) {
        return cmmnEngine.getCmmnHistoryService();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(type={"org.flowable.cmmn.engine.CmmnEngine", "org.flowable.engine.ProcessEngine", "org.flowable.app.engine.AppEngine"})
    static class StandaloneEngineConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringCmmnEngineConfiguration> {
        StandaloneEngineConfiguration() {
        }

        @Bean
        public CmmnEngineFactoryBean cmmnEngine(SpringCmmnEngineConfiguration cmmnEngineConfiguration) {
            CmmnEngineFactoryBean factory = new CmmnEngineFactoryBean();
            factory.setCmmnEngineConfiguration((CmmnEngineConfiguration)cmmnEngineConfiguration);
            this.invokeConfigurers(cmmnEngineConfiguration);
            return factory;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(type={"org.flowable.cmmn.engine.CmmnEngine"})
    @ConditionalOnBean(type={"org.flowable.app.engine.AppEngine"})
    static class AlreadyInitializedAppEngineConfiguration {
        AlreadyInitializedAppEngineConfiguration() {
        }

        @Bean
        public CmmnEngine cmmnEngine(AppEngine appEngine) {
            if (!CmmnEngines.isInitialized()) {
                throw new IllegalStateException("CMMN engine has not been initialized");
            }
            return CmmnEngines.getDefaultCmmnEngine();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(type={"org.flowable.cmmn.engine.CmmnEngine", "org.flowable.app.engine.AppEngine"})
    @ConditionalOnBean(type={"org.flowable.engine.ProcessEngine"})
    static class AlreadyInitializedEngineConfiguration {
        AlreadyInitializedEngineConfiguration() {
        }

        @Bean
        public CmmnEngine cmmnEngine(ProcessEngine processEngine) {
            if (!CmmnEngines.isInitialized()) {
                throw new IllegalStateException("CMMN engine has not been initialized");
            }
            return CmmnEngines.getDefaultCmmnEngine();
        }
    }
}

