/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.history;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.common.rest.api.PaginateRequest;
import org.flowable.engine.HistoryService;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.engine.variable.QueryVariable;
import org.flowable.rest.service.api.history.HistoricTaskInstanceQueryRequest;
import org.flowable.rest.service.api.history.HistoricTaskInstanceResponse;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.task.service.impl.HistoricTaskInstanceQueryProperty;
import org.springframework.beans.factory.annotation.Autowired;

public class HistoricTaskInstanceBaseResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    protected DataResponse<HistoricTaskInstanceResponse> getQueryResponse(HistoricTaskInstanceQueryRequest queryRequest, Map<String, String> allRequestParams, String serverRootUrl) {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        if (queryRequest.getTaskId() != null) {
            query.taskId(queryRequest.getTaskId());
        }
        if (queryRequest.getProcessInstanceId() != null) {
            query.processInstanceId(queryRequest.getProcessInstanceId());
        }
        if (queryRequest.getProcessInstanceIdWithChildren() != null) {
            query.processInstanceIdWithChildren(queryRequest.getProcessInstanceIdWithChildren());
        }
        if (queryRequest.getProcessBusinessKey() != null) {
            query.processInstanceBusinessKey(queryRequest.getProcessBusinessKey());
        }
        if (queryRequest.getProcessBusinessKeyLike() != null) {
            query.processInstanceBusinessKeyLike(queryRequest.getProcessBusinessKeyLike());
        }
        if (queryRequest.getProcessDefinitionKey() != null) {
            query.processDefinitionKey(queryRequest.getProcessDefinitionKey());
        }
        if (queryRequest.getProcessDefinitionKeyLike() != null) {
            query.processDefinitionKeyLike(queryRequest.getProcessDefinitionKeyLike());
        }
        if (queryRequest.getProcessDefinitionId() != null) {
            query.processDefinitionId(queryRequest.getProcessDefinitionId());
        }
        if (queryRequest.getProcessDefinitionName() != null) {
            query.processDefinitionName(queryRequest.getProcessDefinitionName());
        }
        if (queryRequest.getProcessDefinitionNameLike() != null) {
            query.processDefinitionNameLike(queryRequest.getProcessDefinitionNameLike());
        }
        if (queryRequest.getExecutionId() != null) {
            query.executionId(queryRequest.getExecutionId());
        }
        if (queryRequest.getTaskName() != null) {
            query.taskName(queryRequest.getTaskName());
        }
        if (queryRequest.getTaskNameLike() != null) {
            query.taskNameLike(queryRequest.getTaskNameLike());
        }
        if (queryRequest.getTaskDescription() != null) {
            query.taskDescription(queryRequest.getTaskDescription());
        }
        if (queryRequest.getTaskDescriptionLike() != null) {
            query.taskDescriptionLike(queryRequest.getTaskDescriptionLike());
        }
        if (queryRequest.getTaskDefinitionKey() != null) {
            query.taskDefinitionKey(queryRequest.getTaskDefinitionKey());
        }
        if (queryRequest.getTaskDefinitionKeyLike() != null) {
            query.taskDefinitionKeyLike(queryRequest.getTaskDefinitionKeyLike());
        }
        if (queryRequest.getTaskDefinitionKeys() != null) {
            query.taskDefinitionKeys(queryRequest.getTaskDefinitionKeys());
        }
        if (queryRequest.getTaskCategory() != null) {
            query.taskCategory(queryRequest.getTaskCategory());
        }
        if (queryRequest.getTaskDeleteReason() != null) {
            query.taskDeleteReason(queryRequest.getTaskDeleteReason());
        }
        if (queryRequest.getTaskDeleteReasonLike() != null) {
            query.taskDeleteReasonLike(queryRequest.getTaskDeleteReasonLike());
        }
        if (queryRequest.getTaskAssignee() != null) {
            query.taskAssignee(queryRequest.getTaskAssignee());
        }
        if (queryRequest.getTaskAssigneeLike() != null) {
            query.taskAssigneeLike(queryRequest.getTaskAssigneeLike());
        }
        if (queryRequest.getTaskOwner() != null) {
            query.taskOwner(queryRequest.getTaskOwner());
        }
        if (queryRequest.getTaskOwnerLike() != null) {
            query.taskOwnerLike(queryRequest.getTaskOwnerLike());
        }
        if (queryRequest.getTaskInvolvedUser() != null) {
            query.taskInvolvedUser(queryRequest.getTaskInvolvedUser());
        }
        if (queryRequest.getTaskPriority() != null) {
            query.taskPriority(queryRequest.getTaskPriority());
        }
        if (queryRequest.getTaskMinPriority() != null) {
            query.taskMinPriority(queryRequest.getTaskMinPriority());
        }
        if (queryRequest.getTaskMaxPriority() != null) {
            query.taskMaxPriority(queryRequest.getTaskMaxPriority());
        }
        if (queryRequest.getTaskPriority() != null) {
            query.taskPriority(queryRequest.getTaskPriority());
        }
        if (queryRequest.getFinished() != null) {
            if (queryRequest.getFinished().booleanValue()) {
                query.finished();
            } else {
                query.unfinished();
            }
        }
        if (queryRequest.getProcessFinished() != null) {
            if (queryRequest.getProcessFinished().booleanValue()) {
                query.processFinished();
            } else {
                query.processUnfinished();
            }
        }
        if (queryRequest.getParentTaskId() != null) {
            query.taskParentTaskId(queryRequest.getParentTaskId());
        }
        if (queryRequest.getDueDate() != null) {
            query.taskDueDate(queryRequest.getDueDate());
        }
        if (queryRequest.getDueDateAfter() != null) {
            query.taskDueAfter(queryRequest.getDueDateAfter());
        }
        if (queryRequest.getDueDateBefore() != null) {
            query.taskDueBefore(queryRequest.getDueDateBefore());
        }
        if (queryRequest.getWithoutDueDate() != null && queryRequest.getWithoutDueDate().booleanValue()) {
            query.withoutTaskDueDate();
        }
        if (queryRequest.getTaskCreatedOn() != null) {
            query.taskCreatedOn(queryRequest.getTaskCreatedOn());
        }
        if (queryRequest.getTaskCreatedBefore() != null) {
            query.taskCreatedBefore(queryRequest.getTaskCreatedBefore());
        }
        if (queryRequest.getTaskCreatedAfter() != null) {
            query.taskCreatedAfter(queryRequest.getTaskCreatedAfter());
        }
        if (queryRequest.getTaskCreatedOn() != null) {
            query.taskCreatedOn(queryRequest.getTaskCreatedOn());
        }
        if (queryRequest.getTaskCreatedBefore() != null) {
            query.taskCreatedBefore(queryRequest.getTaskCreatedBefore());
        }
        if (queryRequest.getTaskCreatedAfter() != null) {
            query.taskCreatedAfter(queryRequest.getTaskCreatedAfter());
        }
        if (queryRequest.getTaskCompletedOn() != null) {
            query.taskCompletedOn(queryRequest.getTaskCompletedOn());
        }
        if (queryRequest.getTaskCompletedBefore() != null) {
            query.taskCompletedBefore(queryRequest.getTaskCompletedBefore());
        }
        if (queryRequest.getTaskCompletedAfter() != null) {
            query.taskCompletedAfter(queryRequest.getTaskCompletedAfter());
        }
        if (queryRequest.getIncludeTaskLocalVariables() != null && queryRequest.getIncludeTaskLocalVariables().booleanValue()) {
            query.includeTaskLocalVariables();
        }
        if (queryRequest.getIncludeProcessVariables() != null && queryRequest.getIncludeProcessVariables().booleanValue()) {
            query.includeProcessVariables();
        }
        if (queryRequest.getTaskVariables() != null) {
            this.addTaskVariables(query, queryRequest.getTaskVariables());
        }
        if (queryRequest.getProcessVariables() != null) {
            this.addProcessVariables(query, queryRequest.getProcessVariables());
        }
        if (queryRequest.getScopeDefinitionId() != null) {
            query.scopeDefinitionId(queryRequest.getScopeDefinitionId());
        }
        if (queryRequest.getScopeId() != null) {
            query.scopeId(queryRequest.getScopeId());
        }
        if (queryRequest.getScopeType() != null) {
            query.scopeType(queryRequest.getScopeType());
        }
        if (queryRequest.getTenantId() != null) {
            query.taskTenantId(queryRequest.getTenantId());
        }
        if (queryRequest.getTenantIdLike() != null) {
            query.taskTenantIdLike(queryRequest.getTenantIdLike());
        }
        if (Boolean.TRUE.equals(queryRequest.getWithoutTenantId())) {
            query.taskWithoutTenantId();
        }
        if (Boolean.TRUE.equals(queryRequest.getWithoutDeleteReason())) {
            query.taskWithoutDeleteReason();
        }
        if (queryRequest.getTaskCandidateGroup() != null) {
            query.taskCandidateGroup(queryRequest.getTaskCandidateGroup());
        }
        if (queryRequest.isIgnoreTaskAssignee()) {
            query.ignoreAssigneeValue();
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoryTaskInfoWithQuery(query, queryRequest);
        }
        return PaginateListUtil.paginateList(allRequestParams, (PaginateRequest)queryRequest, (Query)query, (String)"taskInstanceId", allowedSortProperties, this.restResponseFactory::createHistoricTaskInstanceResponseList);
    }

    protected HistoricTaskInstance getHistoricTaskInstanceFromRequest(String taskId) {
        HistoricTaskInstance taskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (taskInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find a task instance with id '" + taskId + "'.", HistoricTaskInstance.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoryTaskInfoById(taskInstance);
        }
        return taskInstance;
    }

    protected void addTaskVariables(HistoricTaskInstanceQuery taskInstanceQuery, List<QueryVariable> variables) {
        block12: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new FlowableIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new FlowableIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = this.restResponseFactory.getVariableValue(variable);
            if (nameLess) {
                throw new FlowableIllegalArgumentException("Value-only query (without a variable-name) is not supported.");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    taskInstanceQuery.taskVariableValueEquals(variable.getName(), actualValue);
                    continue block12;
                }
                case EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        taskInstanceQuery.taskVariableValueEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block12;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case NOT_EQUALS: {
                    taskInstanceQuery.taskVariableValueNotEquals(variable.getName(), actualValue);
                    continue block12;
                }
                case NOT_EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        taskInstanceQuery.taskVariableValueNotEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block12;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case GREATER_THAN: {
                    taskInstanceQuery.taskVariableValueGreaterThan(variable.getName(), actualValue);
                    continue block12;
                }
                case GREATER_THAN_OR_EQUALS: {
                    taskInstanceQuery.taskVariableValueGreaterThanOrEqual(variable.getName(), actualValue);
                    continue block12;
                }
                case LESS_THAN: {
                    taskInstanceQuery.taskVariableValueLessThan(variable.getName(), actualValue);
                    continue block12;
                }
                case LESS_THAN_OR_EQUALS: {
                    taskInstanceQuery.taskVariableValueLessThanOrEqual(variable.getName(), actualValue);
                    continue block12;
                }
                case LIKE: {
                    if (actualValue instanceof String) {
                        taskInstanceQuery.taskVariableValueLike(variable.getName(), (String)actualValue);
                        continue block12;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported using like, but was: " + actualValue.getClass().getName());
                }
                case LIKE_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        taskInstanceQuery.taskVariableValueLikeIgnoreCase(variable.getName(), (String)actualValue);
                        continue block12;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported using like, but was: " + actualValue.getClass().getName());
                }
            }
            throw new FlowableIllegalArgumentException("Unsupported variable query operation: " + (Object)((Object)variable.getVariableOperation()));
        }
    }

    protected void addProcessVariables(HistoricTaskInstanceQuery taskInstanceQuery, List<QueryVariable> variables) {
        block12: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new FlowableIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new FlowableIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = this.restResponseFactory.getVariableValue(variable);
            if (nameLess) {
                throw new FlowableIllegalArgumentException("Value-only query (without a variable-name) is not supported.");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    taskInstanceQuery.processVariableValueEquals(variable.getName(), actualValue);
                    continue block12;
                }
                case EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        taskInstanceQuery.processVariableValueEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block12;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case NOT_EQUALS: {
                    taskInstanceQuery.processVariableValueNotEquals(variable.getName(), actualValue);
                    continue block12;
                }
                case NOT_EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        taskInstanceQuery.processVariableValueNotEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block12;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case GREATER_THAN: {
                    taskInstanceQuery.processVariableValueGreaterThan(variable.getName(), actualValue);
                    continue block12;
                }
                case GREATER_THAN_OR_EQUALS: {
                    taskInstanceQuery.processVariableValueGreaterThanOrEqual(variable.getName(), actualValue);
                    continue block12;
                }
                case LESS_THAN: {
                    taskInstanceQuery.processVariableValueLessThan(variable.getName(), actualValue);
                    continue block12;
                }
                case LESS_THAN_OR_EQUALS: {
                    taskInstanceQuery.processVariableValueLessThanOrEqual(variable.getName(), actualValue);
                    continue block12;
                }
                case LIKE: {
                    if (actualValue instanceof String) {
                        taskInstanceQuery.processVariableValueLike(variable.getName(), (String)actualValue);
                        continue block12;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported using like, but was: " + actualValue.getClass().getName());
                }
                case LIKE_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        taskInstanceQuery.processVariableValueLikeIgnoreCase(variable.getName(), (String)actualValue);
                        continue block12;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported using like, but was: " + actualValue.getClass().getName());
                }
            }
            throw new FlowableIllegalArgumentException("Unsupported variable query operation: " + (Object)((Object)variable.getVariableOperation()));
        }
    }

    static {
        allowedSortProperties.put("deleteReason", (QueryProperty)HistoricTaskInstanceQueryProperty.DELETE_REASON);
        allowedSortProperties.put("duration", (QueryProperty)HistoricTaskInstanceQueryProperty.DURATION);
        allowedSortProperties.put("endTime", (QueryProperty)HistoricTaskInstanceQueryProperty.END);
        allowedSortProperties.put("executionId", (QueryProperty)HistoricTaskInstanceQueryProperty.EXECUTION_ID);
        allowedSortProperties.put("taskInstanceId", (QueryProperty)HistoricTaskInstanceQueryProperty.HISTORIC_TASK_INSTANCE_ID);
        allowedSortProperties.put("processDefinitionId", (QueryProperty)HistoricTaskInstanceQueryProperty.PROCESS_DEFINITION_ID);
        allowedSortProperties.put("processInstanceId", (QueryProperty)HistoricTaskInstanceQueryProperty.PROCESS_INSTANCE_ID);
        allowedSortProperties.put("start", (QueryProperty)HistoricTaskInstanceQueryProperty.START);
        allowedSortProperties.put("assignee", (QueryProperty)HistoricTaskInstanceQueryProperty.TASK_ASSIGNEE);
        allowedSortProperties.put("taskDefinitionKey", (QueryProperty)HistoricTaskInstanceQueryProperty.TASK_DEFINITION_KEY);
        allowedSortProperties.put("description", (QueryProperty)HistoricTaskInstanceQueryProperty.TASK_DESCRIPTION);
        allowedSortProperties.put("dueDate", (QueryProperty)HistoricTaskInstanceQueryProperty.TASK_DUE_DATE);
        allowedSortProperties.put("name", (QueryProperty)HistoricTaskInstanceQueryProperty.TASK_NAME);
        allowedSortProperties.put("owner", (QueryProperty)HistoricTaskInstanceQueryProperty.TASK_OWNER);
        allowedSortProperties.put("priority", (QueryProperty)HistoricTaskInstanceQueryProperty.TASK_PRIORITY);
        allowedSortProperties.put("tenantId", (QueryProperty)HistoricTaskInstanceQueryProperty.TENANT_ID_);
        allowedSortProperties.put("startTime", (QueryProperty)HistoricTaskInstanceQueryProperty.START);
    }
}

