/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Interface;
import org.flowable.bpmn.model.Operation;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ValidatorImpl;

public class OperationValidator
extends ValidatorImpl {
    @Override
    public void validate(BpmnModel bpmnModel, List<ValidationError> errors) {
        if (bpmnModel.getInterfaces() != null) {
            for (Interface bpmnInterface : bpmnModel.getInterfaces()) {
                if (bpmnInterface.getOperations() == null) continue;
                for (Operation operation : bpmnInterface.getOperations()) {
                    if (bpmnModel.getMessage(operation.getInMessageRef()) != null) continue;
                    this.addError(errors, "flowable-operation-invalid-in-message-reference", (BaseElement)operation, "Invalid inMessageRef for operation");
                }
            }
        }
    }
}

