/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.osgi.blueprint;

import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.impl.ProcessEngineImpl;
import org.flowable.osgi.blueprint.BundleDelegatingClassLoader;
import org.flowable.osgi.blueprint.ClassLoaderWrapper;
import org.osgi.framework.Bundle;

public class ProcessEngineFactory {
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected Bundle bundle;
    protected ProcessEngineImpl processEngine;

    public void init() throws Exception {
        ClassLoader previous = Thread.currentThread().getContextClassLoader();
        try {
            BundleDelegatingClassLoader cl = new BundleDelegatingClassLoader(this.bundle);
            Thread.currentThread().setContextClassLoader(new ClassLoaderWrapper(cl, ProcessEngineFactory.class.getClassLoader(), ProcessEngineConfiguration.class.getClassLoader(), previous));
            this.processEngineConfiguration.setClassLoader((ClassLoader)cl);
            this.processEngine = (ProcessEngineImpl)this.processEngineConfiguration.buildProcessEngine();
        }
        finally {
            Thread.currentThread().setContextClassLoader(previous);
        }
    }

    public void destroy() throws Exception {
        if (this.processEngine != null) {
            this.processEngine.close();
        }
    }

    public ProcessEngine getObject() throws Exception {
        return this.processEngine;
    }

    public ProcessEngineConfiguration getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfiguration processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }
}

