/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.flowable.osgi.BarTransformer;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarURLHandler
extends AbstractURLStreamHandlerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BarURLHandler.class);
    private static final String SYNTAX = "bar: bar-xml-uri";
    private URL barXmlURL;

    public URLConnection openConnection(URL url) throws IOException {
        if (url.getPath() == null || url.getPath().trim().length() == 0) {
            throw new MalformedURLException("Path can not be null or empty. Syntax: bar: bar-xml-uri");
        }
        this.barXmlURL = new URL(url.getPath());
        LOGGER.debug("bar xml URL is: [{}]", (Object)this.barXmlURL);
        return new Connection(url);
    }

    public URL getBarXmlURL() {
        return this.barXmlURL;
    }

    public class Connection
    extends URLConnection {
        public Connection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            PipedInputStream pin = new PipedInputStream();
            final PipedOutputStream pout = new PipedOutputStream(pin);
            new Thread(){

                @Override
                public void run() {
                    try {
                        BarTransformer.transform(BarURLHandler.this.barXmlURL, pout);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Bundle cannot be generated");
                    }
                    finally {
                        try {
                            pout.close();
                        }
                        catch (IOException ignore) {
                            LOGGER.error("Bundle cannot be generated", (Throwable)ignore);
                        }
                    }
                }
            }.start();
            return pin;
        }
    }
}

