/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.osgi;

import java.io.OutputStream;
import java.net.URL;
import java.util.TreeSet;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

public class BarTransformer {
    private static final String DEFAULT_VERSION = "0.0.0";
    private static final Pattern ARTIFACT_MATCHER = Pattern.compile("(.+)(?:-(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?(?:[^a-zA-Z0-9](.*))?)(?:\\.([^\\.]+))", 32);
    private static final Pattern FUZZY_MODIFIDER = Pattern.compile("(?:\\d+[.-])*(.*)", 32);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transform(URL url, OutputStream os) throws Exception {
        String pathHeader;
        String name = url.getPath();
        int idx = name.lastIndexOf(47);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        String[] str = BarTransformer.extractNameVersionType(name);
        try (JarInputStream jis = new JarInputStream(url.openStream());){
            ZipEntry e;
            TreeSet<String> paths = new TreeSet<String>();
            while ((e = jis.getNextEntry()) != null) {
                String n = e.getName();
                int i = n.lastIndexOf(47);
                if (-1 == i) {
                    paths.add("/");
                    continue;
                }
                if (i >= n.length() - 1) continue;
                paths.add(n.substring(0, i + 1));
            }
            StringBuilder sb = new StringBuilder();
            for (String s : paths) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(s);
            }
            pathHeader = sb.toString();
        }
        jis = new JarInputStream(url.openStream());
        try {
            JarOutputStream jos = new JarOutputStream(os);
            jos.setLevel(0);
            Manifest m = jis.getManifest();
            if (m == null) {
                m = new Manifest();
                m.getMainAttributes().putValue("Manifest-Version", "2");
            }
            if (m.getMainAttributes().getValue("Bundle-ManifestVersion") == null) {
                m.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
            }
            if (m.getMainAttributes().getValue("Bundle-SymbolicName") == null) {
                m.getMainAttributes().putValue("Bundle-SymbolicName", str[0]);
            }
            if (m.getMainAttributes().getValue("Bundle-Version") == null) {
                m.getMainAttributes().putValue("Bundle-Version", str[1]);
            }
            m.getMainAttributes().putValue("Flowable-Bundle", pathHeader);
            ZipEntry e = new ZipEntry("META-INF/MANIFEST.MF");
            jos.putNextEntry(e);
            m.write(jos);
            jos.closeEntry();
            byte[] readBuffer = new byte[8192];
            while ((e = jis.getNextEntry()) != null) {
                ZipEntry e2 = new ZipEntry(e.getName());
                jos.putNextEntry(e2);
                int bytesIn = jis.read(readBuffer);
                while (bytesIn != -1) {
                    jos.write(readBuffer, 0, bytesIn);
                    bytesIn = jis.read(readBuffer);
                }
                jos.closeEntry();
            }
            jos.finish();
            jos.flush();
        }
        finally {
            jis.close();
        }
    }

    public static String[] extractNameVersionType(String url) {
        Matcher m = ARTIFACT_MATCHER.matcher(url);
        if (!m.matches()) {
            return new String[]{url, DEFAULT_VERSION};
        }
        StringBuffer v = new StringBuffer();
        String d1 = m.group(1);
        String d2 = m.group(2);
        String d3 = m.group(3);
        String d4 = m.group(4);
        String d5 = m.group(5);
        String d6 = m.group(6);
        if (d2 != null) {
            v.append(d2);
            if (d3 != null) {
                v.append('.');
                v.append(d3);
                if (d4 != null) {
                    v.append('.');
                    v.append(d4);
                    if (d5 != null) {
                        v.append(".");
                        BarTransformer.cleanupModifier(v, d5);
                    }
                } else if (d5 != null) {
                    v.append(".0.");
                    BarTransformer.cleanupModifier(v, d5);
                }
            } else if (d5 != null) {
                v.append(".0.0.");
                BarTransformer.cleanupModifier(v, d5);
            }
        }
        return new String[]{d1, v.toString(), d6};
    }

    private static void cleanupModifier(StringBuffer result, String modifier) {
        Matcher m = FUZZY_MODIFIDER.matcher(modifier);
        if (m.matches()) {
            modifier = m.group(1);
        }
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') && c != '-') continue;
            result.append(c);
        }
    }
}

