/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.flowable.job.service.impl.persistence.entity.JobByteArrayEntity;
import org.flowable.job.service.impl.persistence.entity.JobByteArrayEntityManager;
import org.flowable.job.service.impl.util.CommandContextUtil;

public class JobByteArrayRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private JobByteArrayEntity entity;
    protected boolean deleted;

    public JobByteArrayRef() {
    }

    public JobByteArrayRef(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBytes() {
        this.ensureInitialized();
        return this.entity != null ? this.entity.getBytes() : null;
    }

    public String asString() {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public void setValue(String name, byte[] bytes) {
        this.name = name;
        this.setBytes(bytes);
    }

    public void setValue(String name, String value) {
        this.name = name;
        if (value != null) {
            this.setBytes(value.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void setBytes(byte[] bytes) {
        if (this.id == null) {
            if (bytes != null) {
                JobByteArrayEntityManager byteArrayEntityManager = CommandContextUtil.getJobByteArrayEntityManager();
                this.entity = (JobByteArrayEntity)byteArrayEntityManager.create();
                this.entity.setName(this.name);
                this.entity.setBytes(bytes);
                byteArrayEntityManager.insert(this.entity);
                this.id = this.entity.getId();
            }
        } else {
            this.ensureInitialized();
            this.entity.setBytes(bytes);
        }
    }

    public JobByteArrayEntity getEntity() {
        this.ensureInitialized();
        return this.entity;
    }

    public void delete() {
        if (!this.deleted && this.id != null) {
            if (this.entity != null) {
                CommandContextUtil.getJobByteArrayEntityManager().delete(this.entity);
            } else {
                CommandContextUtil.getJobByteArrayEntityManager().deleteByteArrayById(this.id);
            }
            this.entity = null;
            this.id = null;
            this.deleted = true;
        }
    }

    private void ensureInitialized() {
        if (this.id != null && this.entity == null) {
            this.entity = (JobByteArrayEntity)CommandContextUtil.getJobByteArrayEntityManager().findById(this.id);
            this.name = this.entity.getName();
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public JobByteArrayRef copy() {
        JobByteArrayRef copy = new JobByteArrayRef();
        copy.id = this.id;
        copy.name = this.name;
        copy.entity = this.entity;
        copy.deleted = this.deleted;
        return copy;
    }

    public String toString() {
        return "ByteArrayRef[id=" + this.id + ", name=" + this.name + ", entity=" + this.entity + (this.deleted ? ", deleted]" : "]");
    }
}

