/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.spring.authentication;

import org.flowable.idm.api.PasswordSalt;
import org.springframework.security.crypto.password.PasswordEncoder;

public class SpringEncoder
implements org.flowable.idm.api.PasswordEncoder {
    private org.springframework.security.authentication.encoding.PasswordEncoder encodingPasswordEncoder;
    private PasswordEncoder cryptoPasswordEncoder;

    public SpringEncoder(org.springframework.security.authentication.encoding.PasswordEncoder passwordEncoder) {
        this.encodingPasswordEncoder = passwordEncoder;
    }

    public SpringEncoder(PasswordEncoder passwordEncoder) {
        this.cryptoPasswordEncoder = passwordEncoder;
    }

    public String encode(CharSequence rawPassword, PasswordSalt passwordSalt) {
        if (null == this.encodingPasswordEncoder) {
            return this.cryptoPasswordEncoder.encode(rawPassword);
        }
        return this.encodingPasswordEncoder.encodePassword(rawPassword.toString(), (Object)passwordSalt);
    }

    public boolean isMatches(CharSequence rawPassword, String encodedPassword, PasswordSalt passwordSalt) {
        if (null == this.encodingPasswordEncoder) {
            return this.cryptoPasswordEncoder.matches(rawPassword, encodedPassword);
        }
        return this.encodingPasswordEncoder.isPasswordValid(encodedPassword, rawPassword.toString(), (Object)passwordSalt);
    }

    public Object getSpringEncodingProvider() {
        return null == this.encodingPasswordEncoder ? this.cryptoPasswordEncoder : this.encodingPasswordEncoder;
    }
}

