/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.http.common.api;

import java.util.ArrayList;
import java.util.Collection;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.http.common.api.HttpHeaders;
import org.flowable.http.common.api.MultiValuePart;

public class HttpRequest {
    protected String method;
    protected String url;
    protected HttpHeaders httpHeaders;
    protected String body;
    protected String bodyEncoding;
    protected Collection<MultiValuePart> multiValueParts;
    protected int timeout;
    protected boolean noRedirects;

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public String getHttpHeadersAsString() {
        return this.httpHeaders != null ? this.httpHeaders.formatAsString() : null;
    }

    public void setHttpHeaders(HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        if (this.multiValueParts != null && !this.multiValueParts.isEmpty()) {
            throw new FlowableIllegalStateException("Cannot set both body and multi value parts");
        }
        this.body = body;
    }

    public String getBodyEncoding() {
        return this.bodyEncoding;
    }

    public void setBodyEncoding(String bodyEncoding) {
        this.bodyEncoding = bodyEncoding;
    }

    public Collection<MultiValuePart> getMultiValueParts() {
        return this.multiValueParts;
    }

    public void addMultiValuePart(MultiValuePart part) {
        if (this.body != null) {
            throw new FlowableIllegalStateException("Cannot set both body and multi value parts");
        }
        if (this.multiValueParts == null) {
            this.multiValueParts = new ArrayList<MultiValuePart>();
        }
        this.multiValueParts.add(part);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isNoRedirects() {
        return this.noRedirects;
    }

    public void setNoRedirects(boolean noRedirects) {
        this.noRedirects = noRedirects;
    }
}

