/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.rest.service.api.form;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.form.rest.service.api.form.BaseFormInstanceResource;
import org.flowable.form.rest.service.api.form.FormInstanceQueryRequest;
import org.flowable.form.rest.service.api.form.FormInstanceResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Form Instances"}, description="Manage Form Instances", authorizations={@Authorization(value="basicAuth")})
public class FormInstanceQueryResource
extends BaseFormInstanceResource {
    @ApiOperation(value="Query form instances", tags={"Form Instances", "Query"}, notes="The request body can contain all possible filters that can be used in the List form instances URL query. On top of these, it\u2019s possible to provide an array of variables to include in the query, with their format described here.\n\nThe general paging and sorting query-parameters can be used for this URL.")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the form instances are returned"), @ApiResponse(code=400, message="Indicates a parameter was passed in the wrong format . The status-message contains additional information.")})
    @PostMapping(value={"/query/form-instances"}, produces={"application/json"})
    public DataResponse<FormInstanceResponse> queryFormInstances(@RequestBody FormInstanceQueryRequest queryRequest, @ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        return this.getQueryResponse(queryRequest, allRequestParams);
    }
}

