/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.job.rest.service.api;

import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.ManagementService;
import org.flowable.external.job.rest.service.api.ExternalWorkerJobRestApiInterceptor;
import org.flowable.job.api.ExternalWorkerJob;
import org.flowable.job.api.ExternalWorkerJobQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class ExternalWorkerJobBaseResource {
    protected ManagementService managementService;
    protected CmmnManagementService cmmnManagementService;
    protected ExternalWorkerJobRestApiInterceptor restApiInterceptor;

    protected ExternalWorkerJobQuery createExternalWorkerJobQuery() {
        if (this.managementService != null) {
            return this.managementService.createExternalWorkerJobQuery();
        }
        if (this.cmmnManagementService != null) {
            return this.cmmnManagementService.createExternalWorkerJobQuery();
        }
        throw new FlowableException("Cannot query external jobs. There is no BPMN or CMMN engine available");
    }

    protected ExternalWorkerJob getExternalWorkerJobById(String jobId) {
        ExternalWorkerJob job = (ExternalWorkerJob)this.createExternalWorkerJobQuery().jobId(jobId).singleResult();
        if (job == null) {
            throw new FlowableObjectNotFoundException("Could not find external worker job with id '" + jobId + "'.", ExternalWorkerJob.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessExternalWorkerJobById(job);
        }
        return job;
    }

    @Autowired(required=false)
    public void setManagementService(ManagementService managementService) {
        this.managementService = managementService;
    }

    @Autowired(required=false)
    public void setCmmnManagementService(CmmnManagementService cmmnManagementService) {
        this.cmmnManagementService = cmmnManagementService;
    }

    @Autowired(required=false)
    public void setRestApiInterceptor(ExternalWorkerJobRestApiInterceptor restApiInterceptor) {
        this.restApiInterceptor = restApiInterceptor;
    }
}

