/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.db;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.db.EngineSchemaManagerLockConfiguration;
import org.flowable.common.engine.impl.db.EngineSqlScriptBasedDbSchemaManager;
import org.flowable.common.engine.impl.db.SchemaManagerLockConfiguration;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class EventDbSchemaManager
extends EngineSqlScriptBasedDbSchemaManager {
    protected static final String EVENTREGISTRY_DB_SCHEMA_LOCK_NAME = "eventRegistryDbSchemaLock";
    protected static final Map<String, String> changeLogVersionMap = Map.ofEntries(Map.entry("1", "6.5.0.6"), Map.entry("2", "6.7.2.0"), Map.entry("3", "6.7.2.0"), Map.entry("4", "7.1.0.0"), Map.entry("5", "7.1.0.0"));

    public EventDbSchemaManager() {
        super("eventregistry", (SchemaManagerLockConfiguration)new EngineSchemaManagerLockConfiguration(CommandContextUtil::getEventRegistryConfiguration));
    }

    protected String getEngineVersion() {
        return "7.1.0.2";
    }

    protected String getSchemaVersionPropertyName() {
        return "eventregistry.schema.version";
    }

    protected String getDbSchemaLockName() {
        return EVENTREGISTRY_DB_SCHEMA_LOCK_NAME;
    }

    protected String getEngineTableName() {
        return "FLW_EVENT_DEFINITION";
    }

    protected String getChangeLogTableName() {
        return "FLW_EV_DATABASECHANGELOG";
    }

    protected String getDbVersionForChangelogVersion(String changeLogVersion) {
        if (StringUtils.isNotEmpty((CharSequence)changeLogVersion) && changeLogVersionMap.containsKey(changeLogVersion)) {
            return changeLogVersionMap.get(changeLogVersion);
        }
        return "6.5.0.0";
    }

    protected String getResourcesRootDirectory() {
        return "org/flowable/eventregistry/db/";
    }
}

